/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.zip.Deflater;

class HBuffer {
    static final int BLEN = 10000;
    private FileChannel outChannel;
    int compressionLevel;
    HdfFileWriter hdfFile;
    private ByteBuffer bbuf;
    Deflater deflater;

    HBuffer(FileChannel outChannel, int compressionLevel, HdfFileWriter hdfFile) throws HdfException {
        this.outChannel = outChannel;
        this.compressionLevel = compressionLevel;
        this.hdfFile = hdfFile;
        this.bbuf = ByteBuffer.allocate(10000);
        this.bbuf.order(ByteOrder.LITTLE_ENDIAN);
        if (compressionLevel > 0) {
            if (outChannel == null) {
                HBuffer.throwerr("cannot have compressionLevel > 0 with no outChannel", new Object[0]);
            }
            this.deflater = new Deflater(compressionLevel);
        }
        if (hdfFile.bugs >= 5) {
            HBuffer.prtf("HBuffer: outChannel: %s  compressionLevel: %d", outChannel == null ? "no" : "yes", compressionLevel);
        }
    }

    public String toString() {
        String res = "outChannel:";
        if (this.outChannel == null) {
            res = res + " null";
        } else {
            try {
                res = res + " pos: " + this.outChannel.position();
            }
            catch (IOException exc) {
                exc.printStackTrace();
                res = res + " pos: " + exc + "  caught: " + exc;
            }
        }
        res = res + "  bbuf: " + this.bbuf;
        return res;
    }

    void clear() {
        this.bbuf.clear();
    }

    int getPos() {
        return this.bbuf.position();
    }

    void setPos(long pos) throws HdfException {
        if (pos < 0L || pos >= (long)this.bbuf.capacity()) {
            HBuffer.throwerr("invalid setPos", new Object[0]);
        }
        this.bbuf.position((int)pos);
    }

    byte[] getBufBytes(long startPos, long limPos) throws HdfException {
        if (startPos < 0L || startPos > (long)this.getPos()) {
            HBuffer.throwerr("invalid startPos", new Object[0]);
        }
        if (limPos < startPos || limPos > (long)this.getPos()) {
            HBuffer.throwerr("invalid limPos", new Object[0]);
        }
        int blen = (int)(limPos - startPos);
        byte[] bytes = new byte[blen];
        for (int ii = 0; ii < blen; ++ii) {
            bytes[ii] = this.bbuf.get((int)startPos + ii);
        }
        return bytes;
    }

    void writeChannel(FileChannel chan) throws HdfException {
        if (this.hdfFile.bugs >= 5) {
            HBuffer.prtf("writeChannel: bbuf: pos: %d  limit: %d  capacity: %d", this.getPos(), this.bbuf.limit(), this.bbuf.capacity());
        }
        if (this.outChannel != null) {
            HBuffer.throwerr("two channels specified", new Object[0]);
        }
        if (this.compressionLevel > 0) {
            HBuffer.throwerr("compression not supported here", new Object[0]);
        }
        this.bbuf.flip();
        try {
            chan.write(this.bbuf);
        }
        catch (IOException exc) {
            exc.printStackTrace();
            HBuffer.throwerr("caught: %s", exc);
        }
        this.bbuf.clear();
    }

    private void expandBuf(int idelta) throws HdfException {
        if (this.getPos() + idelta > this.bbuf.capacity()) {
            if (this.outChannel == null) {
                int newLen = 100 + 2 * (this.getPos() + idelta);
                if (this.hdfFile.bugs >= 10) {
                    HBuffer.prtf("expandBuf: expand A: getPos: %d  idelta: %d  newLen: %d", this.getPos(), idelta, newLen);
                }
                ByteBuffer newbuf = ByteBuffer.allocateDirect(newLen);
                newbuf.order(ByteOrder.LITTLE_ENDIAN);
                byte[] oldVals = new byte[this.getPos()];
                this.bbuf.flip();
                this.bbuf.get(oldVals);
                newbuf.put(oldVals);
                this.bbuf = newbuf;
            } else {
                if (this.hdfFile.bugs >= 10) {
                    HBuffer.prtf("expandBuf: write: getPos: %d  idelta: %d  compressionLevel: %d", this.getPos(), idelta, this.compressionLevel);
                }
                try {
                    if (this.compressionLevel > 0) {
                        this.writeCompressedOutput();
                    } else {
                        this.bbuf.flip();
                        this.outChannel.write(this.bbuf);
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                    HBuffer.throwerr("caught: %s", exc);
                }
                this.bbuf.clear();
                if (idelta > this.bbuf.capacity()) {
                    int newLen = 100 + 2 * idelta;
                    if (this.hdfFile.bugs >= 10) {
                        HBuffer.prtf("expandBuf: expand with outChannel: idelta: %d  newLen: %d", idelta, newLen);
                    }
                    this.bbuf = ByteBuffer.allocateDirect(newLen);
                    this.bbuf.order(ByteOrder.LITTLE_ENDIAN);
                }
            }
        }
    }

    private void writeCompressedOutput() throws IOException, HdfException {
        int compLen;
        if (this.hdfFile.bugs >= 5) {
            HBuffer.prtf("writeCompressedOutput.entry:", new Object[0]);
            HBuffer.prtf("  bbuf: pos: %d  limit: %d  capacity: %d", this.getPos(), this.bbuf.limit(), this.bbuf.capacity());
            HBuffer.prtf("  outChannel: pos: %d", this.outChannel.position());
        }
        byte[] bytes = new byte[this.getPos()];
        this.bbuf.flip();
        this.bbuf.get(bytes);
        this.deflater.setInput(bytes, 0, this.bbuf.position());
        byte[] compBytes = new byte[10000];
        ByteBuffer cbuf = ByteBuffer.wrap(compBytes);
        cbuf.order(ByteOrder.LITTLE_ENDIAN);
        while ((compLen = this.deflater.deflate(compBytes)) != 0) {
            cbuf.position(0);
            cbuf.limit(compLen);
            this.outChannel.write(cbuf);
        }
        if (this.hdfFile.bugs >= 5) {
            HBuffer.prtf("writeCompressedOutput.exit:", new Object[0]);
            HBuffer.prtf("  outChannel: pos: %d", this.outChannel.position());
        }
    }

    void flush() throws IOException, HdfException {
        if (this.outChannel == null) {
            HBuffer.throwerr("cannot flush null channel", new Object[0]);
        }
        if (this.hdfFile.bugs >= 5) {
            HBuffer.prtf("flush.entry: outChannel.pos: %d", this.outChannel.position());
        }
        try {
            if (this.compressionLevel > 0) {
                this.deflater.finish();
                this.writeCompressedOutput();
                this.deflater.end();
            } else {
                this.bbuf.flip();
                this.outChannel.write(this.bbuf);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
            HBuffer.throwerr("caught: %s", exc);
        }
        this.bbuf.clear();
        if (this.hdfFile.bugs >= 5) {
            HBuffer.prtf("flush.exit: outChannel.pos: %d", this.outChannel.position());
        }
    }

    long alignPos(String msg, long bound) throws HdfException {
        int fillByte = 119;
        int oldPos = this.getPos();
        while ((long)this.getPos() % bound != 0L) {
            this.putBufByte("align fill", fillByte);
        }
        return this.getPos();
    }

    void putBufByte(String name, int value) throws HdfException {
        this.expandBuf(1);
        if (value < 0 || value > 255) {
            HBuffer.throwerr("putBufByte: invalid value: " + value, new Object[0]);
        }
        if (this.hdfFile.bugs >= 5) {
            this.printValue(1, name, new Byte((byte)(0xFF & value)));
        }
        this.bbuf.put((byte)value);
    }

    void putBufBytes(String name, byte[] values) throws HdfException {
        this.expandBuf(values.length);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(values.length, name, values);
        }
        this.bbuf.put(values);
    }

    void putBufShort(String name, int value) throws HdfException {
        this.expandBuf(2);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(2, name, new Short((short)value));
        }
        this.bbuf.putShort((short)value);
    }

    void putBufInt(String name, int value) throws HdfException {
        this.expandBuf(4);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(4, name, new Integer(value));
        }
        this.bbuf.putInt(value);
    }

    void putBufLong(String name, long value) throws HdfException {
        this.expandBuf(8);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(8, name, new Long(value));
        }
        this.bbuf.putLong(value);
    }

    void putBufFloat(String name, float value) throws HdfException {
        this.expandBuf(4);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(4, name, new Float(value));
        }
        this.bbuf.putFloat(value);
    }

    void putBufDouble(String name, double value) throws HdfException {
        this.expandBuf(8);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(8, name, new Double(value));
        }
        this.bbuf.putDouble(value);
    }

    void putBufBuf(String name, HBuffer inBuf) throws HdfException {
        int inLen = inBuf.getPos();
        this.expandBuf(inLen);
        byte[] inBytes = inBuf.getBufBytes(0L, inLen);
        if (this.hdfFile.bugs >= 5) {
            this.printValue(inLen, name, inBytes);
        }
        this.bbuf.put(inBytes);
    }

    private void printValue(int len, String name, Object value) throws HdfException {
        if (name != null) {
            String decStg = null;
            StringBuilder hexBuf = new StringBuilder();
            if (value instanceof Byte) {
                hexBuf.append(String.format("%02x", 0xFF & (Byte)value));
                decStg = "" + (0xFF & (Byte)value);
            } else if (value instanceof Short) {
                hexBuf.append(String.format("%04x", 0xFFFF & (Short)value));
                decStg = "" + (0xFFFF & (Short)value);
            } else if (value instanceof Integer) {
                hexBuf.append(String.format("%08x", (int)((Integer)value)));
                decStg = "" + value;
            } else if (value instanceof Long) {
                hexBuf.append(String.format("%016x", (long)((Long)value)));
                decStg = "" + value;
            } else if (value instanceof Float) {
                decStg = "" + value;
            } else if (value instanceof Double) {
                decStg = "" + value;
            } else if (value instanceof byte[]) {
                for (byte bb : (byte[])value) {
                    hexBuf.append(String.format("%02x", 0xFF & bb));
                }
            } else {
                HBuffer.throwerr("unknown type: " + value.getClass(), new Object[0]);
            }
            String msg = String.format("%s  len: %d", this.hdfFile.formatName(name, this.bbuf.position()), len);
            if (hexBuf.length() > 0) {
                msg = msg + "  hex: " + hexBuf.toString();
            }
            if (decStg != null) {
                msg = msg + "  dec: " + decStg;
            }
            HBuffer.prtf(msg, new Object[0]);
        }
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }

    static void throwerr(String msg, Object ... args) throws HdfException {
        throw new HdfException(String.format(msg, args));
    }
}

