/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;

public class ExampleSimple {
    public static void main(String[] args) {
        try {
            ExampleSimple.testIt(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            ExampleSimple.prtln("caught: " + exc);
            System.exit(1);
        }
    }

    static void badParms(String msg) {
        ExampleSimple.prtln("Error: " + msg);
        ExampleSimple.prtln("Parms:");
        ExampleSimple.prtln("  -outFile  <fileName>");
        System.exit(1);
    }

    static void testIt(String[] args) throws Exception {
        if (args.length != 2) {
            ExampleSimple.badParms("wrong num parms");
        }
        if (!args[0].equals("-outFile")) {
            ExampleSimple.badParms("missing parm: -outFile");
        }
        String fileName = args[1];
        int option = 1;
        HdfFileWriter hdfFile = new HdfFileWriter(fileName, option);
        ExampleSimple.prtln("hdfFile: " + hdfFile);
        HdfGroup rootGroup = hdfFile.getRootGroup();
        int numx = 10;
        int numy = 10;
        int[] dims = new int[]{numx, numy};
        int[] specChunkDims = null;
        HdfGroup humidity = rootGroup.addVariable("humidity", 7, 0, dims, specChunkDims, new Double(-999999.0), 0);
        ExampleSimple.prtln("humidity: " + humidity);
        humidity.addAttribute("units", 9, 0, "celsius", false);
        specChunkDims = new int[]{5, 10};
        HdfGroup temperature = rootGroup.addVariable("temperature", 7, 0, dims, specChunkDims, new Double(-999999.0), 0);
        ExampleSimple.prtln("temperature: " + temperature);
        hdfFile.endDefine();
        double[][] humidityData = new double[numx][numy];
        for (int ix = 0; ix < numx; ++ix) {
            for (int iy = 0; iy < numy; ++iy) {
                humidityData[ix][iy] = 100 * ix + iy;
            }
        }
        double[][] temperatureDataChunk0 = new double[specChunkDims[0]][specChunkDims[1]];
        double[][] temperatureDataChunk1 = new double[specChunkDims[0]][specChunkDims[1]];
        for (int ix = 0; ix < specChunkDims[0]; ++ix) {
            for (int iy = 0; iy < specChunkDims[1]; ++iy) {
                temperatureDataChunk0[ix][iy] = 100 * ix + iy + 1000;
                temperatureDataChunk1[ix][iy] = 100 * ix + iy + 2000;
            }
        }
        int[] startIxs = null;
        humidity.writeData(startIxs, humidityData, false);
        startIxs = new int[]{0, 0};
        temperature.writeData(startIxs, temperatureDataChunk0, false);
        startIxs[0] = 5;
        temperature.writeData(startIxs, temperatureDataChunk1, false);
        hdfFile.close();
        ExampleSimple.prtln("All done");
    }

    static void prtln(String msg) {
        System.out.println(msg);
    }
}

