/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.BaseBlk;
import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfChunk;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import java.util.ArrayList;

class BtreeNode
extends BaseBlk {
    HdfGroup hdfGroup;
    ArrayList<byte[]> keyList;
    int compressionLevel;
    final int signa = 84;
    final int signb = 82;
    final int signc = 69;
    final int signd = 69;
    int nodeLevel;
    final byte[] lowKey = new byte[5];
    final byte[] highKey = new byte[]{-1, -1, -1, -1, -1};

    BtreeNode(int compressionLevel, HdfGroup hdfGroup, HdfFileWriter hdfFile) {
        super("BtreeNode", hdfFile);
        this.compressionLevel = compressionLevel;
        this.hdfGroup = hdfGroup;
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  nodeLevel: " + this.nodeLevel;
        res = res + "  group: \"" + this.hdfGroup.groupName + "\"";
        return res;
    }

    @Override
    void formatBuf(int formatPass, HBuffer fmtBuf) throws HdfException {
        this.setFormatEntry(formatPass, true, fmtBuf);
        int numChunk = this.hdfGroup.hdfChunks.length;
        if (numChunk > this.hdfFile.maxNumBtreeKid) {
            this.hdfFile.maxNumBtreeKid = numChunk;
        }
        fmtBuf.putBufByte("BtreeNode: signa", 84);
        fmtBuf.putBufByte("BtreeNode: signb", 82);
        fmtBuf.putBufByte("BtreeNode: signc", 69);
        fmtBuf.putBufByte("BtreeNode: signd", 69);
        fmtBuf.putBufByte("BtreeNode: nodeType", 1);
        fmtBuf.putBufByte("BtreeNode: nodeLevel", this.nodeLevel);
        fmtBuf.putBufShort("BtreeNode: numChunk", numChunk);
        fmtBuf.putBufLong("BtreeNode: leftSibling.pos", -1L);
        fmtBuf.putBufLong("BtreeNode: rightSibling.pos", -1L);
        int filterMask = 0;
        for (int ichunk = 0; ichunk < this.hdfGroup.hdfChunks.length; ++ichunk) {
            HdfChunk chunk = this.hdfGroup.hdfChunks[ichunk];
            fmtBuf.putBufInt("BtreeNode: chunkSize", (int)chunk.chunkDataSize);
            fmtBuf.putBufInt("BtreeNode: key filterMask", filterMask);
            for (int ii = 0; ii < this.hdfGroup.varRank; ++ii) {
                fmtBuf.putBufLong("BtreeNode: key startIx", chunk.chunkStartIxs[ii]);
            }
            fmtBuf.putBufLong("BtreeNode: key eleLen offset", 0L);
            fmtBuf.putBufLong("BtreeNode: chunk addr", chunk.chunkDataAddr);
        }
        fmtBuf.putBufInt("BtreeNode: final key chunkSize", 0);
        fmtBuf.putBufInt("BtreeNode: final key filterMask", filterMask);
        for (int jj = 0; jj < this.hdfGroup.varRank; ++jj) {
            fmtBuf.putBufLong("BtreeNode: final key dimOffset", this.hdfGroup.varDims[jj]);
        }
        fmtBuf.putBufLong("BtreeNode: final key eleLen offset", this.hdfGroup.msgDataType.elementLen);
        int safe_k_value = 128;
        for (int ii = 0; ii < 2 * safe_k_value - 1; ++ii) {
            fmtBuf.putBufLong("BtreeNode: fill chunk addr", 0L);
            fmtBuf.putBufInt("BtreeNode: fill key chunkSize", 0);
            fmtBuf.putBufInt("BtreeNode: fill key mask", 0);
            for (int jj = 0; jj < this.hdfGroup.msgDataSpace.rank; ++jj) {
                fmtBuf.putBufLong("BtreeNode: fill key dimOffset", 0L);
            }
            fmtBuf.putBufLong("BtreeNode: fill key eleLen offset", 0L);
        }
        this.noteFormatExit(fmtBuf);
    }
}

