/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.globcover;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class GlobCoverModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "GlobCover";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "GlobCover");
    private static final File[] fileList = new File[]{new File(INSTALL_DIR, "globecover_1.tif.zip"), new File(INSTALL_DIR, "globecover_2.tif.zip"), new File(INSTALL_DIR, "globecover_3.tif.zip"), new File(INSTALL_DIR, "globecover_4.tif.zip"), new File(INSTALL_DIR, "globecover_5.tif.zip"), new File(INSTALL_DIR, "globecover_6.tif.zip"), new File(INSTALL_DIR, "globecover_7.tif.zip"), new File(INSTALL_DIR, "globecover_8.tif.zip"), new File(INSTALL_DIR, "globecover_9.tif.zip"), new File(INSTALL_DIR, "globecover_10.tif.zip"), new File(INSTALL_DIR, "globecover_11.tif.zip"), new File(INSTALL_DIR, "globecover_12.tif.zip"), new File(INSTALL_DIR, "globecover_13.tif.zip"), new File(INSTALL_DIR, "globecover_14.tif.zip"), new File(INSTALL_DIR, "globecover_15.tif.zip"), new File(INSTALL_DIR, "globecover_16.tif.zip"), new File(INSTALL_DIR, "globecover_17.tif.zip"), new File(INSTALL_DIR, "globecover_18.tif.zip"), new File(INSTALL_DIR, "globecover_19.tif.zip"), new File(INSTALL_DIR, "globecover_20.tif.zip"), new File(INSTALL_DIR, "globecover_21.tif.zip"), new File(INSTALL_DIR, "globecover_22.tif.zip"), new File(INSTALL_DIR, "globecover_23.tif.zip"), new File(INSTALL_DIR, "globecover_24.tif.zip"), new File(INSTALL_DIR, "globecover_25.tif.zip"), new File(INSTALL_DIR, "globecover_26.tif.zip"), new File(INSTALL_DIR, "globecover_27.tif.zip"), new File(INSTALL_DIR, "globecover_28.tif.zip"), new File(INSTALL_DIR, "globecover_29.tif.zip"), new File(INSTALL_DIR, "globecover_30.tif.zip"), new File(INSTALL_DIR, "globecover_31.tif.zip"), new File(INSTALL_DIR, "globecover_32.tif.zip"), new File(INSTALL_DIR, "globecover_33.tif.zip"), new File(INSTALL_DIR, "globecover_34.tif.zip"), new File(INSTALL_DIR, "globecover_35.tif.zip"), new File(INSTALL_DIR, "globecover_36.tif.zip")};

    public GlobCoverModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/globcover/";
        this.name = NAME;
        this.NO_DATA_VALUE = 230.0;
        this.installDir = INSTALL_DIR;
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/globcover/globcover_index.col");
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverModel(this, fileList, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return fileList[0].getName();
    }

    @Override
    public boolean isInstalled() {
        return true;
    }
}

