/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.MODIS_VCF;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.FileLandCoverTile;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;
import uk.me.jstott.jcoord.LatLng;

public class FileLandCoverUTMZoneLatBandModel
extends FileLandCoverModel {
    private HashMap<Character, HashMap<Integer, String>> latLonZonesMap = new HashMap();
    private Map<String, FileLandCoverTile> tileMap = new HashMap<String, FileLandCoverTile>();

    public FileLandCoverUTMZoneLatBandModel(LandCoverModelDescriptor descriptor, File[] files, Resampling resamplingMethod) throws IOException {
        super(descriptor, files, resamplingMethod);
        this.buildLatBandAndLonZoneIDMaps();
    }

    @Override
    public synchronized double getLandCover(GeoPos geoPos) throws Exception {
        try {
            LatLng ll = new LatLng(geoPos.lat, geoPos.lon);
            char latBandID = FileLandCoverUTMZoneLatBandModel.getLatBand(ll.getLat());
            int lonZoneID = ll.toUTMRef().getLngZone();
            String tileID = this.getTileID(latBandID, lonZoneID);
            if (tileID != null) {
                FileLandCoverTile tile = this.tileMap.get(tileID);
                if (tile == null) {
                    tile = this.loadProduct(tileID);
                }
                if (tile != null && tile.getTileGeocoding() != null) {
                    PixelPos pix = tile.getTileGeocoding().getPixelPos(geoPos, null);
                    if (!pix.isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)tile.getWidth() || pix.y >= (double)tile.getHeight()) {
                        return tile.getNoDataValue();
                    }
                    this.resampling.computeIndex(pix.x, pix.y, tile.getWidth(), tile.getHeight(), this.resamplingIndex);
                    double value = this.resampling.resample((Resampling.Raster)tile, this.resamplingIndex);
                    if (Double.isNaN(value)) {
                        return tile.getNoDataValue();
                    }
                    return value;
                }
            }
            return this.descriptor.getNoDataValue();
        }
        catch (Exception e) {
            throw new Exception("Problem reading : " + e.getMessage());
        }
    }

    private FileLandCoverTile loadProduct(String tileID) throws Exception {
        for (File file : this.fileList) {
            if (!file.getName().contains(tileID)) continue;
            FileLandCoverTile tile = new FileLandCoverTile(this, file, productReaderPlugIn.createReaderInstance());
            this.tileMap.put(tileID, tile);
            this.tileList = this.tileMap.values().toArray(new FileLandCoverTile[this.tileMap.size()]);
            return tile;
        }
        return null;
    }

    private String getTileID(char latBandID, int lonZoneID) {
        HashMap<Integer, String> map = this.latLonZonesMap.get(Character.valueOf(latBandID));
        return map == null ? null : map.get(lonZoneID);
    }

    private void buildLatBandAndLonZoneIDMaps() {
        for (File f : this.fileList) {
            String tileID = f.getName().substring(19, 25);
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 4; j += 2) {
                    Character latBandID = Character.valueOf(tileID.charAt(i));
                    int zoneID = Integer.parseInt(tileID.substring(2 + j, 4 + j));
                    HashMap<Integer, String> map = this.latLonZonesMap.get(latBandID);
                    if (map == null) {
                        map = new HashMap();
                        this.latLonZonesMap.put(latBandID, map);
                    }
                    map.put(zoneID, tileID);
                }
            }
        }
    }

    private static char getLatBand(double lat) {
        if (lat < -80.0 || lat > 84.0) {
            return ' ';
        }
        if (lat >= 72.0) {
            return 'X';
        }
        if (lat < -32.0) {
            int tmp = (int)(lat + 80.0) / 8;
            return (char)(tmp + 67);
        }
        if (lat < 8.0) {
            int tmp = (int)(lat + 32.0) / 8;
            return (char)(tmp + 74);
        }
        int tmp = (int)(lat - 8.0) / 8;
        return (char)(tmp + 80);
    }
}

