/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.io.IOException;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.landcover.dataio.LandCoverModel;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.LandCoverModelRegistry;

public class LandCoverFactory {
    private static final String AUTO = " (Auto Download)";
    private static final LandCoverModelDescriptor[] descriptors = LandCoverModelRegistry.getInstance().getAllDescriptors();
    private static final String[] nameList = new String[descriptors.length];

    public static String[] getNameList() {
        return nameList;
    }

    public static String getProperName(String name) {
        return name.replace(AUTO, "");
    }

    public static LandCoverModel createLandCoverModel(String name, String resamplingMethod) throws IOException {
        LandCoverModelRegistry registry = LandCoverModelRegistry.getInstance();
        LandCoverModelDescriptor descriptor = registry.getDescriptor(name);
        if (descriptor == null) {
            throw new OperatorException("The land cover '" + name + "' is not supported.");
        }
        Resampling resampling = ResamplingFactory.createResampling((String)resamplingMethod);
        if (resampling == null) {
            throw new OperatorException("Resampling method " + resamplingMethod + " is invalid");
        }
        LandCoverModel landcover = descriptor.createLandCoverModel(resampling);
        if (landcover == null) {
            throw new OperatorException("The land cover '" + name + "' has not been installed.");
        }
        return landcover;
    }

    public static void checkIfInstalled(String name) {
        LandCoverModelRegistry registry = LandCoverModelRegistry.getInstance();
        LandCoverModelDescriptor descriptor = registry.getDescriptor(name);
        if (descriptor == null) {
            throw new OperatorException("The land cover '" + name + "' is not supported.");
        }
        if (!(descriptor.isInstalling() || descriptor.isInstalled() || descriptor.installFiles())) {
            throw new OperatorException("Land cover " + name + " must be installed first");
        }
    }

    public static String appendAutoDownload(String name) {
        return name;
    }

    public static boolean getLocalLandCover(LandCoverModel landcover, float noDataValue, TileGeoreferencing tileGeoRef, int x0, int y0, int tileWidth, int tileHeight, double[][] localLandCover) throws Exception {
        int maxY = y0 + tileHeight + 1;
        int maxX = x0 + tileWidth + 1;
        GeoPos geoPos = new GeoPos();
        boolean valid = false;
        for (int y = y0 - 1; y < maxY; ++y) {
            int yy = y - y0 + 1;
            for (int x = x0 - 1; x < maxX; ++x) {
                tileGeoRef.getGeoPos(x, y, geoPos);
                double alt = landcover.getLandCover(geoPos);
                if (!valid && alt != (double)noDataValue) {
                    valid = true;
                }
                localLandCover[yy][x - x0 + 1] = alt;
            }
        }
        return valid;
    }

    static {
        for (int i = 0; i < descriptors.length; ++i) {
            LandCoverFactory.nameList[i] = LandCoverFactory.appendAutoDownload(descriptors[i].getName());
        }
    }
}

