/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;

public abstract class AbstractLandCoverModelDescriptor
implements LandCoverModelDescriptor {
    protected String name;
    protected double NO_DATA_VALUE = -9999.0;
    protected String unit = "class";
    protected File installDir = null;
    protected String remotePath = null;
    protected Path colourIndexFile = null;
    protected String metadataFileName = null;
    protected Path metadataSrcPath = null;
    protected boolean isInstalled = false;
    private final List<ColorPaletteDef.Point> colorPalettePoints = new ArrayList<ColorPaletteDef.Point>(50);

    protected AbstractLandCoverModelDescriptor() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumXTiles() {
        return 0;
    }

    @Override
    public int getNumYTiles() {
        return 0;
    }

    @Override
    public double getNoDataValue() {
        return this.NO_DATA_VALUE;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public int getDegreeRes() {
        return 0;
    }

    @Override
    public int getPixelRes() {
        return 0;
    }

    @Override
    public boolean isInstalled() {
        return this.isInstalled;
    }

    @Override
    public URL getArchiveUrl() {
        try {
            return new URL(this.remotePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }

    @Override
    public boolean isInstalling() {
        return false;
    }

    @Override
    public synchronized boolean installFiles() {
        this.installMetadata();
        if (this.installDir != null) {
            File[] files = this.installDir.listFiles();
            this.isInstalled = files != null && files.length > 0;
        }
        return this.isInstalled;
    }

    @Override
    public ImageInfo getImageInfo() {
        return new ImageInfo(new ColorPaletteDef(this.colorPalettePoints.toArray(new ColorPaletteDef.Point[this.colorPalettePoints.size()]), this.colorPalettePoints.size()));
    }

    @Override
    public int getDataType() {
        return 11;
    }

    @Override
    public IndexCoding getIndexCoding() {
        if (this.colourIndexFile != null) {
            if (this.colorPalettePoints.isEmpty()) {
                this.readColorIndex();
            }
            if (!this.colorPalettePoints.isEmpty()) {
                return this.createIndexCoding();
            }
        }
        return null;
    }

    private IndexCoding createIndexCoding() {
        IndexCoding indexCoding = new IndexCoding("Crop Indices");
        for (ColorPaletteDef.Point p : this.colorPalettePoints) {
            indexCoding.addIndex(p.getLabel(), (int)p.getSample(), "");
        }
        return indexCoding;
    }

    private void readColorIndex() {
        DefaultPropertyMap prop = new DefaultPropertyMap();
        try {
            prop.load(this.colourIndexFile);
        }
        catch (IOException e) {
            SystemUtils.LOG.warning("Unable to read color file " + this.colourIndexFile);
            return;
        }
        int size = prop.getProperties().size();
        ArrayList<String> classNameList = new ArrayList<String>(size);
        HashMap<String, ColorPaletteDef.Point> classMap = new HashMap<String, ColorPaletteDef.Point>(size);
        Set keys = prop.getPropertyKeys();
        for (String key : keys) {
            try {
                Integer value = Integer.parseInt(key);
                String str = prop.getPropertyString(key);
                int c = str.indexOf("Color(");
                int c1 = c + 6;
                int c2 = str.lastIndexOf(41);
                String name = StringUtils.padNum((int)value, (int)4, (char)' ') + ' ' + str.substring(0, c).trim();
                String colStr = str.substring(c1, c2);
                Color col = StringUtils.parseColor((String)colStr);
                classNameList.add(name);
                classMap.put(name, new ColorPaletteDef.Point((double)value.intValue(), col, name));
            }
            catch (Exception e) {
                SystemUtils.LOG.warning("Unable to read color file " + this.colourIndexFile);
            }
        }
        Collections.sort(classNameList);
        for (String name : classNameList) {
            this.colorPalettePoints.add((ColorPaletteDef.Point)classMap.get(name));
        }
    }

    protected void installMetadata() {
        try {
            if (this.metadataFileName != null) {
                File file = new File(this.installDir, this.metadataFileName);
                if (file.exists()) {
                    return;
                }
                ResourceInstaller resourceInstaller = new ResourceInstaller(this.metadataSrcPath, this.installDir.toPath());
                resourceInstaller.install(".*", ProgressMonitor.NULL);
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("Unable to install land cover metadata " + this.installDir);
        }
    }
}

