/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.FileLandCoverTile;
import org.esa.snap.landcover.dataio.LandCoverModelDescriptor;

public class FileLandCoverProvincialModel
extends FileLandCoverModel {
    private List<TileData> tileDataList = new ArrayList<TileData>();

    public FileLandCoverProvincialModel(LandCoverModelDescriptor descriptor, File[] files, Resampling resamplingMethod) throws IOException {
        super(descriptor, files, resamplingMethod);
        this.tileDataList.add(new TileData(53.9112841586466, -114.73990703906945, files[0]));
        this.tileDataList.add(new TileData(52.914088704678846, -122.32311551754088, files[1]));
        this.tileDataList.add(new TileData(51.5524862030492, -98.40075508982784, files[2]));
        this.tileDataList.add(new TileData(46.53620643706265, -66.52326514628892, files[3]));
        this.tileDataList.add(new TileData(48.79890293939873, -55.115977591094314, files[4]));
        this.tileDataList.add(new TileData(45.31183706258599, -63.035088294228345, files[5]));
        this.tileDataList.add(new TileData(46.192169447119376, -84.6911456002628, files[6]));
        this.tileDataList.add(new TileData(46.5092422478255, -63.28092434982391, files[7]));
        this.tileDataList.add(new TileData(47.870066633078366, -72.51820504485306, files[8]));
        this.tileDataList.add(new TileData(52.20834616203186, -106.27851934747717, files[9]));
    }

    @Override
    public synchronized double getLandCover(GeoPos geoPos) throws Exception {
        try {
            FileLandCoverTile tile;
            TileData[] tileData = this.getTileData(geoPos);
            if (tileData[0].tile == null) {
                tileData[0].tile = new FileLandCoverTile(this, tileData[0].file, productReaderPlugIn.createReaderInstance());
            }
            if ((tile = tileData[0].tile) != null && tile.getTileGeocoding() != null) {
                PixelPos pix = tile.getTileGeocoding().getPixelPos(geoPos, null);
                if (!pix.isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)tile.getWidth() || pix.y >= (double)tile.getHeight()) {
                    if (tileData[1].tile == null) {
                        tileData[1].tile = new FileLandCoverTile(this, tileData[1].file, productReaderPlugIn.createReaderInstance());
                    }
                    if ((tile = tileData[1].tile) != null && tile.getTileGeocoding() != null && (!(pix = tile.getTileGeocoding().getPixelPos(geoPos, null)).isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)tile.getWidth() || pix.y >= (double)tile.getHeight())) {
                        return tile.getNoDataValue();
                    }
                }
                this.resampling.computeIndex(pix.x, pix.y, tile.getWidth(), tile.getHeight(), this.resamplingIndex);
                double value = this.resampling.resample((Resampling.Raster)tile, this.resamplingIndex);
                if (Double.isNaN(value)) {
                    return tile.getNoDataValue();
                }
                return value;
            }
            return this.descriptor.getNoDataValue();
        }
        catch (Exception e) {
            throw new Exception("Problem reading : " + e.getMessage());
        }
    }

    private TileData[] getTileData(GeoPos geoPos) throws IOException {
        TileData first;
        double lat = geoPos.lat + 90.0;
        double lon = geoPos.lon + 180.0;
        TileData second = first = this.tileDataList.get(0);
        double minDiff = Double.MAX_VALUE;
        for (TileData tileData : this.tileDataList) {
            double diff = Math.abs(lon - tileData.lon);
            if (!(diff < minDiff)) continue;
            second = first;
            first = tileData;
            minDiff = diff;
        }
        return new TileData[]{first, second};
    }

    private static class TileData {
        final double lat;
        final double lon;
        final File file;
        FileLandCoverTile tile;

        TileData(double lat, double lon, File file) {
            this.lat = lat + 90.0;
            this.lon = lon + 180.0;
            this.file = file;
        }
    }
}

