/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio.AAFC;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.engine_utilities.util.Settings;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverUTMModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class AESBEOS2012CropModelDescriptor
extends AbstractLandCoverModelDescriptor {
    public static final String NAME = "AAFC Canada 2012 Crop";
    private static final File INSTALL_DIR = new File(Settings.instance().getAuxDataFolder().getAbsolutePath(), "LandCover" + File.separator + "AAFC" + File.separator + "AESB_EOS_Crop_2012");
    private static final File[] fileList = new File[]{new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM10_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM11_30m_v3.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM12_30m_v3.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM13_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM14_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM15_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM16_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM17_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM18_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM19_30m_v2.zip"), new File(INSTALL_DIR, "STB-EOS_2012_CI_UTM20_30m_v3.zip")};

    public AESBEOS2012CropModelDescriptor() {
        this.remotePath = "http://step.esa.int/auxdata/landcover/AAFC/AESB_EOS_Crop_2012/";
        this.name = NAME;
        this.NO_DATA_VALUE = -9999.0;
        this.installDir = INSTALL_DIR;
        this.metadataFileName = "AAFC_Crop_Mapping_2012_v2_Metadata_EN.xml";
        Path moduleBasePath = ResourceInstaller.findModuleCodeBasePath(this.getClass());
        this.metadataSrcPath = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/AAFC_Crop_Mapping_2012/");
        this.colourIndexFile = moduleBasePath.resolve("org/esa/snap/landcover/auxdata/aafc/aafc_crop_index.col");
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return new FileLandCoverUTMModel(this, fileList, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return fileList[0].getName();
    }
}

