/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public class VMParameters {
    private static final String DEFAULT_OPTION_PROPERTY_KEY = "default_options";
    private static Path snapConfigPath = null;
    private long vmXMX = 0L;
    private long vmXMS = 0L;
    private String otherVMOptions;

    public long getVmXMX() {
        return this.vmXMX;
    }

    public void setVmXMX(long vmXMX) {
        this.vmXMX = vmXMX;
    }

    public long getVmXMS() {
        return this.vmXMS;
    }

    public void setVmXMS(long vmXMS) {
        this.vmXMS = vmXMS;
    }

    public String getOtherVMOptions() {
        return this.otherVMOptions;
    }

    public void setOtherVMOptions(String otherVMOptions) {
        this.otherVMOptions = otherVMOptions;
    }

    public VMParameters(String vmParametersString) {
        this(VMParameters.toParamList(vmParametersString));
    }

    public VMParameters(List<String> vmParametersStringList) {
        if (vmParametersStringList != null) {
            this.fromStringList(vmParametersStringList);
        }
    }

    static void setSnapConfigPath(Path snapConfigPath) {
        VMParameters.snapConfigPath = snapConfigPath;
    }

    static Path getSnapConfigPath() {
        if (snapConfigPath == null) {
            snapConfigPath = Config.instance().installDir().resolve("etc").resolve("snap.conf");
        }
        return snapConfigPath;
    }

    public void fromStringList(List<String> vmParametersStringArray) {
        String otherVMParams = "";
        for (String thisArg : vmParametersStringArray) {
            if (thisArg != null) {
                if (thisArg.startsWith("-Xmx")) {
                    try {
                        this.setVmXMX(this.getMemVmSettingValue(thisArg));
                    }
                    catch (NumberFormatException ex) {
                        SystemUtils.LOG.warning("VM Parameters, bad XMX: " + thisArg);
                    }
                } else if (thisArg.startsWith("-Xms")) {
                    try {
                        this.setVmXMS(this.getMemVmSettingValue(thisArg));
                    }
                    catch (NumberFormatException ex) {
                        SystemUtils.LOG.warning("VM Parameters, bad XMS: " + thisArg);
                    }
                } else if (!thisArg.isEmpty()) {
                    otherVMParams = otherVMParams + thisArg + " ";
                }
            }
            this.setOtherVMOptions(otherVMParams);
        }
    }

    private long getMemVmSettingValue(String vmStringSetting) throws NumberFormatException {
        double multValue;
        String memStringValue = vmStringSetting.substring(4);
        if (memStringValue.endsWith("g") || memStringValue.endsWith("G")) {
            multValue = 1024.0;
            memStringValue = memStringValue.substring(0, memStringValue.length() - 1);
        } else if (memStringValue.endsWith("m") || memStringValue.endsWith("M")) {
            multValue = 1.0;
            memStringValue = memStringValue.substring(0, memStringValue.length() - 1);
        } else if (memStringValue.endsWith("k") || memStringValue.endsWith("K")) {
            multValue = 0.0;
            memStringValue = memStringValue.substring(0, memStringValue.length() - 1);
        } else {
            multValue = 0.0;
        }
        return Math.round((double)Long.parseLong(memStringValue) * multValue);
    }

    static List<String> toParamList(String parametersAsString) {
        ArrayList<String> vmParamsList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'| \"([^\"]*)\"| '([^']*)'");
        Matcher regexMatcher = regex.matcher(parametersAsString);
        while (regexMatcher.find()) {
            if (!(vmParamsList.isEmpty() || regexMatcher.group(1) == null && regexMatcher.group(2) == null || regexMatcher.group(3) != null || regexMatcher.group(4) != null)) {
                int lastAddedIndex = vmParamsList.size() - 1;
                String lastParam = (String)vmParamsList.get(lastAddedIndex) + regexMatcher.group();
                vmParamsList.set(lastAddedIndex, lastParam);
                continue;
            }
            vmParamsList.add(regexMatcher.group());
        }
        return vmParamsList;
    }

    static String toString(List<String> parametersAsList) {
        StringBuilder builder = new StringBuilder();
        for (String parameter : parametersAsList) {
            builder.append(parameter);
            builder.append(' ');
        }
        return builder.toString();
    }

    static VMParameters load() {
        Properties properties = VMParameters.loadSnapConfProperties();
        String defaultParameters = properties.getProperty(DEFAULT_OPTION_PROPERTY_KEY);
        ArrayList<String> vmParameters = null;
        if (defaultParameters != null) {
            if (defaultParameters.startsWith("\"")) {
                defaultParameters = defaultParameters.substring(1, defaultParameters.length() - 1);
            }
            List<String> defaultParametersAsList = VMParameters.toParamList(defaultParameters);
            vmParameters = new ArrayList<String>(defaultParametersAsList.size());
            for (String parameter : defaultParametersAsList) {
                if (!parameter.startsWith("-J")) continue;
                vmParameters.add(parameter.substring(2));
            }
        }
        return new VMParameters(vmParameters);
    }

    private static Properties loadSnapConfProperties() {
        Properties properties = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(VMParameters.getSnapConfigPath());){
            properties.load(reader);
        }
        catch (IOException e) {
            SystemUtils.LOG.severe(String.format("Can't load snap config file '%s'", VMParameters.getSnapConfigPath().toString()));
        }
        return properties;
    }

    public static boolean canSave() {
        return Files.isWritable(VMParameters.getSnapConfigPath());
    }

    void save() throws IOException {
        Properties properties = VMParameters.loadSnapConfProperties();
        String defaultParameters = properties.getProperty(DEFAULT_OPTION_PROPERTY_KEY);
        ArrayList<String> parametersToSave = new ArrayList<String>();
        if (defaultParameters != null) {
            if (defaultParameters.startsWith("\"")) {
                defaultParameters = defaultParameters.substring(1, defaultParameters.length() - 1);
            }
            List<String> defaultParametersAsList = VMParameters.toParamList(defaultParameters);
            for (String defaultParameter : defaultParametersAsList) {
                if (defaultParameter.startsWith("-J")) continue;
                parametersToSave.add(defaultParameter);
            }
        }
        List<String> vmParametersAsList = VMParameters.toParamList(this.toString());
        for (String vmParameter : vmParametersAsList) {
            parametersToSave.add("-J" + vmParameter);
        }
        String vmParametersAsString = VMParameters.toString(parametersToSave);
        vmParametersAsString = StringEscapeUtils.escapeJava((String)vmParametersAsString);
        vmParametersAsString = "\"" + vmParametersAsString + "\"";
        String defaultOptionAsString = "default_options=" + vmParametersAsString;
        List<String> snapConfigLines = Files.readAllLines(VMParameters.getSnapConfigPath());
        if (snapConfigLines != null && snapConfigLines.size() > 0) {
            Iterator<String> configLinesIterator = snapConfigLines.iterator();
            String regex = "default_options[ =:].*";
            BufferedWriter writer = Files.newBufferedWriter(VMParameters.getSnapConfigPath(), new OpenOption[0]);
            do {
                String configLine = configLinesIterator.next();
                snapConfigLines.iterator();
                if (configLine == null) continue;
                if (configLine.matches(regex)) {
                    while (configLine != null && configLine.trim().endsWith("\\")) {
                        configLine = configLinesIterator.next();
                    }
                    writer.write(defaultOptionAsString);
                } else {
                    writer.write(configLine);
                }
                writer.newLine();
            } while (configLinesIterator.hasNext());
            writer.close();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getVmXMX() != 0L) {
            builder.append(" -Xmx");
            builder.append(this.getVmXMX());
            builder.append("m ");
        }
        if (this.getVmXMS() != 0L) {
            builder.append(" -Xms");
            builder.append(this.getVmXMS());
            builder.append("m ");
        }
        if (this.getOtherVMOptions() != null) {
            builder.append(this.getOtherVMOptions());
        }
        return builder.toString();
    }
}

