/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;

public abstract class BenchmarkOperatorProvider {
    private Set<OperatorSpi> benchmarkOperatorSpis = new HashSet<OperatorSpi>();

    protected abstract List<String> getBenchmarkOperatorAliases();

    public BenchmarkOperatorProvider() {
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        Set operatorSpis = spiRegistry.getOperatorSpis();
        List<String> benchmarkOperatorAliases = this.getBenchmarkOperatorAliases();
        for (OperatorSpi operatorSpi : operatorSpis) {
            if (!benchmarkOperatorAliases.contains(operatorSpi.getOperatorAlias())) continue;
            this.benchmarkOperatorSpis.add(operatorSpi);
        }
    }

    public Set<OperatorSpi> getBenchmarkOperators() {
        return this.benchmarkOperatorSpis;
    }
}

