/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_hgt;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTMHGTReader;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class SRTMHGTReaderPlugIn
implements ProductReaderPlugIn {
    public static final String[] FORMAT_NAMES = new String[]{"HGT"};
    private static final String[] FORMAT_FILE_EXTENSIONS = new String[]{"hgt", "hgt.zip"};
    private static final String PLUGIN_DESCRIPTION = "SRTM Height";
    private final Class[] VALID_INPUT_TYPES = new Class[]{File.class, String.class};

    public DecodeQualification getDecodeQualification(Object input) {
        File file = ReaderUtils.getFileFromInput((Object)input);
        if (file != null) {
            String name = file.getName().toLowerCase();
            for (String prodExt : FORMAT_FILE_EXTENSIONS) {
                if (!name.endsWith(prodExt)) continue;
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return this.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new SRTMHGTReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new FileFilter();
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return FORMAT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return PLUGIN_DESCRIPTION;
    }

    public static class FileFilter
    extends SnapFileFilter {
        public FileFilter() {
            super(FORMAT_NAMES[0], FORMAT_FILE_EXTENSIONS, SRTMHGTReaderPlugIn.PLUGIN_DESCRIPTION);
        }

        public boolean accept(File file) {
            if (super.accept(file)) {
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getName().toLowerCase();
                if (name.endsWith(FORMAT_FILE_EXTENSIONS[0]) || name.endsWith(FORMAT_FILE_EXTENSIONS[1])) {
                    return true;
                }
            }
            return false;
        }
    }
}

