/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.srtm1_hgt;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dem.dataio.srtm1_hgt.SRTM1HgtFileInfo;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;

public class SRTMHGTReader
extends AbstractProductReader {
    private ZipFile zipFile;
    private ImageInputStream imageInputStream = null;

    public SRTMHGTReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        File inputFile;
        block7: {
            inputFile = ReaderUtils.getFileFromInput((Object)this.getInput());
            try {
                if (inputFile == null) {
                    throw new IOException("Unable to read hgt file " + this.getInput().toString());
                }
                String ext = FileUtils.getExtension((File)inputFile);
                if (".zip".equalsIgnoreCase(ext)) {
                    ZipFile productZip = new ZipFile(inputFile, 1);
                    Enumeration<? extends ZipEntry> entries = productZip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        String name = zipEntry.getName().toLowerCase();
                        if (!name.endsWith(".hgt")) continue;
                        InputStream inputStream = productZip.getInputStream(zipEntry);
                        this.imageInputStream = new MemoryCacheImageInputStream(inputStream);
                        break block7;
                    }
                    break block7;
                }
                this.imageInputStream = new FileImageInputStream(inputFile);
                this.imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (IOException productZip) {
                    // empty catch block
                }
                throw e;
            }
        }
        int width = 3600;
        int height = 3600;
        Product product = new Product(inputFile.getName(), "HGT", 3600, 3600);
        Band band = new Band("elevation", 11, 3600, 3600);
        band.setUnit("meters");
        product.addBand(band);
        SRTMHGTReader.addGeoCoding(product, inputFile);
        product.setProductReader((ProductReader)this);
        product.setFileLocation(inputFile);
        product.setModified(false);
        return product;
    }

    private static void addGeoCoding(Product product, File inputFile) throws IOException {
        SRTM1HgtFileInfo info = SRTM1HgtFileInfo.create(inputFile);
        float northing = info.getNorthing();
        float easting = info.getEasting();
        float[] lat = new float[]{northing + 1.0f, northing + 1.0f, northing, northing};
        float[] lon = new float[]{easting, easting + 1.0f, easting, easting + 1.0f};
        ReaderUtils.addGeoCoding((Product)product, (float[])lat, (float[])lon);
    }

    public void close() throws IOException {
        super.close();
        if (this.imageInputStream != null) {
            this.imageInputStream.close();
            this.imageInputStream = null;
        }
        if (this.zipFile != null) {
            this.zipFile.close();
            this.zipFile = null;
        }
    }

    protected synchronized void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        try {
            int sourceMaxX = sourceOffsetX + sourceWidth;
            int sourceMaxY = sourceOffsetY + sourceHeight;
            int sourceRasterWidth = destBand.getRasterWidth() + 1;
            int elemSize = destBuffer.getElemSize();
            int bandOffset = 0;
            int destPos = 0;
            for (int sourceY = sourceOffsetY; sourceY < sourceMaxY; sourceY += sourceStepY) {
                long sourcePosY = sourceY * sourceRasterWidth;
                if (sourceStepX == 1) {
                    this.imageInputStream.seek((long)bandOffset + (long)elemSize * (sourcePosY + (long)sourceOffsetX));
                    destBuffer.readFrom(destPos, destWidth, this.imageInputStream);
                    destPos += destWidth;
                    continue;
                }
                for (int sourceX = sourceOffsetX; sourceX < sourceMaxX; sourceX += sourceStepX) {
                    this.imageInputStream.seek((long)bandOffset + (long)elemSize * (sourcePosY + (long)sourceX));
                    destBuffer.readFrom(destPos, 1, this.imageInputStream);
                    ++destPos;
                }
            }
        }
        catch (Throwable e) {
            SystemUtils.LOG.warning("Unable to read SRTM HGT: " + e.getMessage());
        }
    }
}

