/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.cdem;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.BaseElevationModel;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dem.dataio.cdem.CDEMElevationModelDescriptor;
import org.esa.snap.dem.dataio.cdem.CDEMElevationTile;
import org.esa.snap.dem.dataio.cdem.CDEMFile;
import org.esa.snap.engine_utilities.download.downloadablecontent.DownloadableContentImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class CDEMElevationModel
extends BaseElevationModel {
    private static final String DB_FILE_SUFFIX = ".tif";
    private static final ProductReaderPlugIn productReaderPlugIn = CDEMElevationModel.getReaderPlugIn((String)"GeoTIFF");
    private static final String tilePrefix = "cdem_dem_";
    private Map<String, List<CDEMFile>> tileMap = new HashMap<String, List<CDEMFile>>();

    public CDEMElevationModel(CDEMElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        super((ElevationModelDescriptor)descriptor, resamplingMethod);
    }

    public final double getElevation(GeoPos geoPos) throws Exception {
        double indexY = this.getIndexY(geoPos);
        double indexX = this.getIndexX(geoPos);
        if (indexX < 0.0 || indexY < 0.0) {
            return this.NO_DATA_VALUE;
        }
        String folder = indexX < 10.0 ? "0" + (int)indexX + (int)indexY : "" + (int)indexX + (int)indexY;
        List<CDEMFile> cdemFiles = this.tileMap.get(folder);
        if (cdemFiles == null) {
            this.loadTiles(folder);
            cdemFiles = this.tileMap.get(folder);
        }
        if (cdemFiles != null) {
            for (CDEMFile cdemFile : cdemFiles) {
                PixelPos pix;
                CDEMElevationTile tile = (CDEMElevationTile)cdemFile.getTile();
                if (tile == null || tile.getTileGeocoding() == null || (pix = tile.getTileGeocoding().getPixelPos(geoPos, null)) == null || !pix.isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)tile.getWidth() || pix.y >= (double)tile.getHeight()) continue;
                Resampling.Index resamplingIndex = this.resampling.createIndex();
                this.resampling.computeIndex(pix.x, pix.y, tile.getWidth(), tile.getHeight(), resamplingIndex);
                double value = this.resampling.resample((Resampling.Raster)tile, resamplingIndex);
                if (Double.isNaN(value)) {
                    return this.descriptor.getNoDataValue();
                }
                return value;
            }
        }
        return this.descriptor.getNoDataValue();
    }

    private void loadTiles(String folder) {
        File demInstallDir = this.descriptor.getDemInstallDir();
        File demFolder = new File(demInstallDir, folder);
        File[] files = demFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".zip");
            }
        });
        if (files == null || files.length == 0) {
            this.download(folder, demFolder);
        }
        if (files != null && files.length > 0) {
            ArrayList<CDEMFile> tileList = new ArrayList<CDEMFile>();
            for (File file : files) {
                CDEMFile demFile = new CDEMFile(this, file, productReaderPlugIn.createReaderInstance());
                tileList.add(demFile);
            }
            this.tileMap.put(folder, tileList);
        }
    }

    private void download(String folder, File demFolder) {
        List<String> fileList = this.getFileURLs(CDEMFile.getRemoteHTTP() + folder, ".zip");
        for (String fileName : fileList) {
            try {
                File localFile = new File(demFolder, fileName);
                DownloadableContentImpl.getRemoteHttpFile((URL)new URL(CDEMFile.getRemoteHTTP() + folder + "/"), (File)localFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<String> getFileURLs(String path, String ext) {
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            Document doc = Jsoup.connect(path).timeout(10000).validateTLSCertificates(false).get();
            Element table = doc.select("table").first();
            Elements tbRows = table.select("tr");
            for (Element row : tbRows) {
                Elements tbCols = row.select("td");
                for (Element col : tbCols) {
                    Elements elems = col.getElementsByTag("a");
                    for (Element elem : elems) {
                        String link = elem.text();
                        if (!link.endsWith(ext)) continue;
                        fileList.add(elem.text());
                    }
                }
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("Unable to connect to " + path + ": " + e.getMessage());
        }
        return fileList;
    }

    public double getIndexX(GeoPos geoPos) {
        return (int)((geoPos.lon * -1.0 - 48.0) / 8.0);
    }

    public double getIndexY(GeoPos geoPos) {
        return (int)((geoPos.lat - 40.0) / 4.0);
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        double pixelLat = ((double)this.RASTER_HEIGHT - pixelPos.y) * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 60.0;
        double pixelLon = pixelPos.x * this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE - 180.0;
        return new GeoPos(pixelLat, pixelLon);
    }

    protected void createElevationFile(ElevationFile[][] elevationFiles, int x, int y, File demInstallDir) {
        String fileName = this.createTileFilename(x + 1, y + 1);
        File localFile = new File(demInstallDir, fileName);
        elevationFiles[x][y] = new CDEMFile(this, localFile, productReaderPlugIn.createReaderInstance());
    }

    private String createTileFilename(int tileX, int tileY) {
        StringBuilder name = new StringBuilder(tilePrefix);
        if (tileX < 10) {
            name.append('0');
        }
        name.append(tileX);
        name.append('_');
        if (tileY < 10) {
            name.append('0');
        }
        name.append(tileY);
        name.append(DB_FILE_SUFFIX);
        return name.toString();
    }
}

