/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.CachingObjectArray;
import org.esa.snap.dem.dataio.EarthGravitationalModel96;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;

class FileElevationTile {
    private CachingObjectArray linesCache;
    private Product product;
    private static final int maxLines = 500;
    private final List<Integer> indexList = new ArrayList<Integer>(500);
    private boolean useDEMGravitationalModel = true;
    private final EarthGravitationalModel96 egm;
    private final double noDataValue;

    public FileElevationTile(Product product, double noDataValue) throws IOException {
        this.product = product;
        this.noDataValue = noDataValue;
        this.egm = EarthGravitationalModel96.instance();
        this.linesCache = new CachingObjectArray(this.getLineFactory());
        this.linesCache.setCachedRange(0, product.getBandAt(0).getRasterHeight());
    }

    public float getSample(int pixelX, int pixelY) throws IOException {
        float[] line;
        try {
            line = (float[])this.linesCache.getObject(pixelY);
        }
        catch (Exception e) {
            throw FileElevationTile.convertLineCacheException(e);
        }
        return line[pixelX];
    }

    public void dispose() {
        this.clearCache();
        this.linesCache = null;
        if (this.product != null) {
            this.product.dispose();
            this.product = null;
        }
    }

    public void clearCache() {
        this.linesCache.clear();
    }

    private CachingObjectArray.ObjectFactory getLineFactory() {
        final Band band = this.product.getBandAt(0);
        final int width = this.product.getSceneRasterWidth();
        return new CachingObjectArray.ObjectFactory(){

            public Object createObject(int pixelY) throws Exception {
                FileElevationTile.this.updateCache(pixelY);
                float[] line = band.readPixels(0, pixelY, width, 1, new float[width], ProgressMonitor.NULL);
                if (FileElevationTile.this.useDEMGravitationalModel) {
                    FileElevationTile.this.addGravitationalModel(pixelY, line);
                }
                return line;
            }
        };
    }

    private void updateCache(int index) {
        this.indexList.remove((Object)index);
        this.indexList.add(0, index);
        if (this.indexList.size() > 500) {
            int i = this.indexList.size() - 1;
            this.linesCache.setObject(i, null);
            this.indexList.remove(i);
        }
    }

    private static IOException convertLineCacheException(Exception e) {
        IOException ioe;
        if (e instanceof IOException) {
            ioe = (IOException)e;
        } else {
            ioe = new IOException();
            ioe.setStackTrace(e.getStackTrace());
        }
        return ioe;
    }

    public void applyEarthGravitionalModel(boolean flag) {
        this.useDEMGravitationalModel = flag;
    }

    private void addGravitationalModel(int index, float[] line) throws Exception {
        GeoPos geoPos = new GeoPos();
        TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.product, 0, index, line.length, 1);
        double[][] v = new double[4][4];
        for (int i = 0; i < line.length; ++i) {
            if ((double)line[i] == this.noDataValue) continue;
            tileGeoRef.getGeoPos(i, index, geoPos);
            int n = i;
            line[n] = line[n] + this.egm.getEGM(geoPos.lat, geoPos.lon, v);
        }
    }
}

