/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio;

import java.io.File;
import java.io.IOException;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.dem.dataio.FileElevationTile;
import org.esa.snap.engine_utilities.gpf.CommonReaders;

public class FileElevationModel
implements ElevationModel,
Resampling.Raster {
    private Resampling resampling;
    private Resampling.Raster resamplingRaster;
    private GeoCoding tileGeocoding;
    private FileElevationTile fileElevationTile;
    private int RASTER_WIDTH;
    private int RASTER_HEIGHT;
    private Double noDataValue = 0.0;

    public FileElevationModel(File file, String resamplingMethodName, Double demNoDataValue) throws IOException {
        if (resamplingMethodName.equals("DELAUNAY_INTERPOLATION")) {
            throw new IOException("Delaunay interpolation for an external DEM file is currently not supported");
        }
        this.init(file, ResamplingFactory.createResampling((String)resamplingMethodName), demNoDataValue);
    }

    private void init(File file, Resampling resamplingMethod, Double demNoDataValue) throws IOException {
        Product product = CommonReaders.readProduct((File)file);
        if (product == null) {
            throw new IOException("No product reader found for " + file.toString());
        }
        this.RASTER_WIDTH = product.getBandAt(0).getRasterWidth();
        this.RASTER_HEIGHT = product.getBandAt(0).getRasterHeight();
        this.noDataValue = demNoDataValue == null ? Double.valueOf(product.getBandAt(0).getNoDataValue()) : demNoDataValue;
        this.fileElevationTile = new FileElevationTile(product, this.noDataValue);
        this.tileGeocoding = product.getSceneGeoCoding();
        if (this.tileGeocoding == null) {
            throw new IOException(file.toString() + " has an invalid or unsupported geocoding");
        }
        this.resampling = resamplingMethod;
        this.resamplingRaster = this;
    }

    public void dispose() {
        this.fileElevationTile.dispose();
    }

    public ElevationModelDescriptor getDescriptor() {
        return null;
    }

    public double getNoDataValue() {
        return this.noDataValue;
    }

    public Resampling getResampling() {
        return this.resampling;
    }

    public synchronized double getElevation(GeoPos geoPos) throws Exception {
        try {
            PixelPos pix = this.tileGeocoding.getPixelPos(geoPos, null);
            if (!pix.isValid() || pix.x < 0.0 || pix.y < 0.0 || pix.x >= (double)this.RASTER_WIDTH || pix.y >= (double)this.RASTER_HEIGHT) {
                return this.noDataValue;
            }
            Resampling.Index newIndex = this.resampling.createIndex();
            this.resampling.computeCornerBasedIndex(pix.x, pix.y, this.RASTER_WIDTH, this.RASTER_HEIGHT, newIndex);
            double elevation = this.resampling.resample(this.resamplingRaster, newIndex);
            if (Double.isNaN(elevation)) {
                return this.noDataValue;
            }
            return elevation;
        }
        catch (Exception e) {
            throw new Exception("Problem reading DEM: " + e.getMessage());
        }
    }

    public PixelPos getIndex(GeoPos geoPos) {
        return this.tileGeocoding.getPixelPos(geoPos, null);
    }

    public GeoPos getGeoPos(PixelPos pixelPos) {
        return this.tileGeocoding.getGeoPos(pixelPos, null);
    }

    public double getSample(double pixelX, double pixelY) throws IOException {
        double sample = this.fileElevationTile.getSample((int)pixelX, (int)pixelY);
        if (this.noDataValue.equals(sample)) {
            return Double.NaN;
        }
        return sample;
    }

    public int getWidth() {
        return this.RASTER_WIDTH;
    }

    public int getHeight() {
        return this.RASTER_HEIGHT;
    }

    public boolean getSamples(int[] x, int[] y, double[][] samples) throws IOException {
        boolean allValid = true;
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                samples[i][j] = this.fileElevationTile.getSample(x[j], y[i]);
                if (!this.noDataValue.equals(samples[i][j])) continue;
                samples[i][j] = Double.NaN;
                allValid = false;
            }
        }
        return allValid;
    }

    public void applyEarthGravitionalModel(boolean flag) {
        this.fileElevationTile.applyEarthGravitionalModel(flag);
    }
}

