/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.randomForest;

import be.abeel.util.MTRandom;
import java.util.Random;
import net.sf.javaml.classification.Classifier;
import net.sf.javaml.classification.tree.RandomForest;
import org.esa.snap.classification.gpf.BaseClassifier;
import org.esa.snap.classification.gpf.ClassifierDescriptor;
import org.esa.snap.classification.gpf.SupervisedClassifier;

public class RandomForestClassifier
extends BaseClassifier
implements SupervisedClassifier {
    private final int treeCount;

    public RandomForestClassifier(BaseClassifier.ClassifierParams params, int treeCount) {
        super(params);
        this.treeCount = treeCount;
    }

    private static int getNumSplitFeatures(int numberOfFeatures) {
        return (int)Math.sqrt(numberOfFeatures);
    }

    @Override
    public Classifier createMLClassifier(BaseClassifier.FeatureInfo[] featureInfos) {
        int numSplitFeatures = RandomForestClassifier.getNumSplitFeatures(featureInfos.length);
        return new RandomForest(this.treeCount, false, numSplitFeatures, (Random)new MTRandom());
    }

    @Override
    public Classifier retrieveMLClassifier(ClassifierDescriptor classifierDescriptor) {
        return (RandomForest)classifierDescriptor.getObject();
    }

    @Override
    protected Object getXMLInfoToSave(BaseClassifier.ClassifierUserInfo commonInfo) {
        UserInfo userInfo = new UserInfo(commonInfo, this.treeCount);
        return userInfo;
    }

    public static class UserInfo {
        private BaseClassifier.ClassifierUserInfo commonInfo;
        private int numTrees;

        public UserInfo(BaseClassifier.ClassifierUserInfo commonInfo, int numTrees) {
            this.commonInfo = commonInfo;
            this.numTrees = numTrees;
        }
    }
}

