/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.knn;

import net.sf.javaml.classification.Classifier;
import net.sf.javaml.classification.KNearestNeighbors;
import net.sf.javaml.core.Instance;
import org.esa.snap.classification.gpf.BaseClassifier;
import org.esa.snap.classification.gpf.ClassifierDescriptor;
import org.esa.snap.classification.gpf.SupervisedClassifier;
import org.esa.snap.classification.gpf.kdtknn.KDTreeKNNClassifier;

public class KNNClassifier
extends BaseClassifier
implements SupervisedClassifier {
    private int numNeighbours = 5;

    public KNNClassifier(BaseClassifier.ClassifierParams params, int numNeighbours) {
        super(params);
        this.numNeighbours = numNeighbours;
    }

    @Override
    public Classifier createMLClassifier(BaseClassifier.FeatureInfo[] featureInfos) {
        return new KNearestNeighbors(this.numNeighbours);
    }

    @Override
    public Classifier retrieveMLClassifier(ClassifierDescriptor classifierDescriptor) {
        return (KNearestNeighbors)classifierDescriptor.getObject();
    }

    @Override
    protected double getConfidence(Instance instance, Object classVal) {
        return 1.0;
    }

    @Override
    protected Object getXMLInfoToSave(BaseClassifier.ClassifierUserInfo commonInfo) {
        KDTreeKNNClassifier.UserInfo userInfo = new KDTreeKNNClassifier.UserInfo(commonInfo, this.numNeighbours);
        return userInfo;
    }
}

