/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.standalone;

import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CliHandler {
    private Options options = this.createOptions();
    private String[] args;
    private final CommandLineParser parser;

    public CliHandler(String[] args) {
        this.args = args;
        this.parser = new PosixParser();
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        String usage = "java -classpath path com.bc.ceres.standalone.MetadataEngineMain -t /path/targetItem.suff -v templateX=/path/metadata.txt.vm [-v templateY=/path/report.xml.vm] [optional options] [arg1] [arg2] ...";
        formatter.printHelp(usage, this.options);
    }

    public HashMap<String, String> fetchTemplateFiles() throws ParseException {
        String optionName = "v";
        return this.parseKeyValueOption(optionName);
    }

    public HashMap<String, String> fetchSourceItemFiles() throws ParseException {
        String optionName = "S";
        return this.parseKeyValueOption(optionName);
    }

    public String fetchTargetItemFile() throws ParseException {
        return this.parse("t");
    }

    public HashMap<String, String> fetchGlobalMetadataFiles() throws ParseException {
        String optionName = "m";
        return this.parseKeyValueOption(optionName);
    }

    public String[] fetchArguments() throws ParseException {
        CommandLine commandLine = this.parser.parse(this.options, this.args);
        return commandLine.getArgs();
    }

    private HashMap<String, String> parseKeyValueOption(String optionName) throws ParseException {
        CommandLine commandLine = this.parser.parse(this.options, this.args);
        String[] optionValues = commandLine.getOptionValues(optionName);
        HashMap<String, String> keyValues = new HashMap<String, String>();
        if (optionValues != null) {
            for (String optionValue : optionValues) {
                String[] splits = optionValue.split("=");
                if (splits.length != 2) {
                    throw new IllegalArgumentException("Pattern for values of the option -" + optionName + " is: key=value");
                }
                keyValues.put(splits[0], splits[1]);
            }
        }
        return keyValues;
    }

    private String parse(String optionValue) throws ParseException {
        CommandLine commandLine = this.parser.parse(this.options, this.args);
        return commandLine.getOptionValue(optionValue);
    }

    Options createOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"template>=<filePath");
        OptionBuilder.withDescription((String)"The absolute path of the velocity templates (*.vm). Could be several given by key-value-pairs.");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"v"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filePath");
        OptionBuilder.withDescription((String)"The absolute item path (e.g. a product), the metadata file will be placed next to the item. It gets the name 'itemName-templateName.templateSuffix'. Refer to as $targetPath in velocity templates. If the targetPath is a directory, the metadata file will get the name of the velocity template without the suffix *.vm");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"source>=<filePath");
        OptionBuilder.withDescription((String)"Optional. The absolute path and name of the source items. Could be several given by key-value-pairs. In the velocity templates the key will give you the content of the associated metadata file(s). The reference $sourcePaths holds a map of the input item paths. The reference $sourceMetadata holds a map with all source-metadata, which can be referenced by their key. ($sourceMetadata.get(\"source\").get(\"metadata_xml\").content");
        options.addOption(OptionBuilder.create((String)"S"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"myKey>=<filePath");
        OptionBuilder.withDescription((String)"Optional. The absolute path and name of text file(s) (e.g. global metadata, LUTs) to be included as ceres-metadata - Resource. Refer to as $myKey in velocity templates. ($myKey.content; $myKey.map.get(\"key\"), if it was a *.properties file or $myKey.path)");
        options.addOption(OptionBuilder.create((String)"m"));
        return options;
    }
}

