/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.metadata;

import com.bc.ceres.metadata.SimpleFileSystem;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;

public class MetadataResourceResolver {
    public static final String VELOCITY_TEMPLATE_EXTENSION = ".vm";
    private final SimpleFileSystem simpleFileSystem;

    public MetadataResourceResolver(SimpleFileSystem simpleFileSystem) {
        this.simpleFileSystem = simpleFileSystem;
    }

    public SortedMap<String, String> getSourceMetadataPaths(String sourcePath) throws IOException {
        String basename = MetadataResourceResolver.getBasename(sourcePath);
        String dirname = MetadataResourceResolver.getDirname(sourcePath);
        String wantedPrefix = this.removeFileExtension(basename) + "-";
        TreeMap<String, String> sourceNames = new TreeMap<String, String>();
        String[] directoryList = this.simpleFileSystem.list(dirname);
        if (directoryList != null) {
            for (String filename : directoryList) {
                if (filename.equalsIgnoreCase(basename) || !filename.startsWith(wantedPrefix)) continue;
                String metadataBaseName = filename.substring(wantedPrefix.length());
                if (dirname.isEmpty()) {
                    sourceNames.put(metadataBaseName, filename);
                    continue;
                }
                sourceNames.put(metadataBaseName, dirname + "/" + filename);
            }
        }
        return sourceNames;
    }

    public TargetResourceInfo getTargetName(String templatePath, String targetPath) {
        String templateName = MetadataResourceResolver.getBasename(templatePath);
        String templateBaseName = templateName.substring(0, templateName.length() - VELOCITY_TEMPLATE_EXTENSION.length());
        String targetPathWithoutExtension = this.removeFileExtension(targetPath);
        String targetName = targetPath.equals(targetPathWithoutExtension) ? targetPath + "/" + templateBaseName : targetPathWithoutExtension + "-" + templateBaseName;
        return new TargetResourceInfo(templateName, templateBaseName, targetName);
    }

    String removeFileExtension(String path) {
        int i;
        if (this.simpleFileSystem.isFile(path) && (i = path.lastIndexOf(46)) > 0) {
            return path.substring(0, i);
        }
        return path;
    }

    static String getBasename(String path) {
        String pathNormalized = path.replace('\\', '/');
        int i = pathNormalized.lastIndexOf(47);
        if (i >= 0) {
            return pathNormalized.substring(i + 1);
        }
        return pathNormalized;
    }

    static String getDirname(String path) {
        String pathNormalized = path.replace('\\', '/');
        int i = pathNormalized.lastIndexOf(47);
        if (i > 0) {
            return pathNormalized.substring(0, i);
        }
        return "";
    }

    public static class TargetResourceInfo {
        public final String templateName;
        public final String templateBaseName;
        public final String targetName;

        public TargetResourceInfo(String templateName, String templateBaseName, String targetName) {
            this.templateName = templateName;
            this.templateBaseName = templateBaseName;
            this.targetName = targetName;
        }
    }
}

