/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.util;

import java.io.Serializable;

public class TimeInterval
implements Serializable {
    private static final long serialVersionUID = -5251967760337130846L;
    private long milliseconds;
    private long seconds;
    private long minutes;
    private long hours;
    private long days;

    public TimeInterval(String s) {
        String[] d = s.split("d ");
        this.days = Long.parseLong(d[0]);
        String[] h = d[1].split(":");
        this.hours = Long.parseLong(h[0]);
        this.minutes = Long.parseLong(h[1]);
        String[] ms = h[2].split("'");
        this.seconds = Long.parseLong(ms[0]);
        this.milliseconds = Long.parseLong(ms[1]);
    }

    public long getLengthInMilliseconds() {
        return (((24L * this.days + this.hours) * 60L + this.minutes) * 60L + this.seconds) * 1000L + this.milliseconds;
    }

    public TimeInterval(long ms) {
        this.seconds = ms / 1000L;
        this.minutes = this.seconds / 60L;
        this.hours = this.minutes / 60L;
        this.days = this.hours / 24L;
        this.hours %= 24L;
        this.minutes %= 60L;
        this.seconds %= 60L;
        this.milliseconds = ms % 1000L;
    }

    public String toString() {
        return this.days + "d " + this.hours + ":" + (this.minutes < 10L ? "0" + this.minutes : Long.valueOf(this.minutes)) + ":" + (this.seconds < 10L ? "0" + this.seconds : Long.valueOf(this.seconds)) + "'" + this.milliseconds;
    }

    public long getDays() {
        return this.days;
    }

    public long getHours() {
        return this.hours;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getSeconds() {
        return this.seconds;
    }
}

