/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.util;

import be.abeel.graphics.GraphicsFileExport;
import be.abeel.jfreechart.JFreeChartWrapper;
import be.abeel.util.CountMap;
import be.abeel.util.FrequencyMap;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountMapTools {
    public static void plot(CountMap<? extends Comparable<?>> freq, String file) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Comparable i : freq.keySet()) {
            dataset.addValue((Number)freq.get(i), (Comparable)((Object)"count"), i);
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"CountMap bar chart", (String)"Category", (String)"Count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        GraphicsFileExport.exportPNG(new JFreeChartWrapper(chart), file, 800, 600);
    }

    public static void plot(String title, List<FrequencyMap> list, String file, boolean countNormalization, int lower, int upper, String[] labels) {
        int count = 0;
        DefaultXYDataset set = new DefaultXYDataset();
        for (FrequencyMap freq : list) {
            int i;
            double[][] data = new double[2][freq.keySet().size()];
            int index = 0;
            Iterator i$ = freq.keySet().iterator();
            while (i$.hasNext()) {
                i = (Integer)i$.next();
                data[0][index] = i;
                data[1][index] = ((Integer)freq.get(i)).intValue();
                ++index;
            }
            if (countNormalization) {
                int totalCount = freq.totalCount();
                i = 0;
                while (i < data[1].length) {
                    double[] dArray = data[1];
                    int n = i++;
                    dArray[n] = dArray[n] / (double)totalCount;
                }
            }
            set.addSeries((Comparable)((Object)(labels != null ? labels[count++] : "freq" + count++)), data);
        }
        JFreeChart chart = ChartFactory.createXYBarChart((String)title, (String)"bin", (boolean)false, (String)"count", (IntervalXYDataset)new XYBarDataset((XYDataset)set, 1.0), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        if (countNormalization) {
            chart.getXYPlot().getRangeAxis().setRange(0.0, 1.0);
        }
        chart.getXYPlot().getDomainAxis().setRange((double)lower, (double)upper);
        GraphicsFileExport.exportPNG(new JFreeChartWrapper(chart), file, 1024, 768);
    }
}

