/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.io;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFileFilter
implements FileFilter {
    private Vector<String> extension = new Vector();

    private void addExtension(String ext) {
        if (!ext.startsWith("\\.")) {
            ext = "." + ext;
        }
        this.extension.add(ext.toLowerCase());
    }

    public ExtensionFileFilter(List<String> ext) {
        for (String s : ext) {
            this.addExtension(s.toLowerCase());
        }
    }

    public ExtensionFileFilter(String ext) {
        this.addExtension(ext.toLowerCase());
    }

    @Override
    public boolean accept(File file) {
        boolean accept = false;
        for (String s : this.extension) {
            if (!file.getName().endsWith(s)) continue;
            accept = true;
        }
        return accept;
    }
}

