/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Copier<T> {
    public T copy(T orig) {
        Object obj = null;
        try {
            FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(fbos);
            out.writeObject(orig);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(fbos.getInputStream());
            obj = in.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return (T)obj;
    }

    public class FastByteArrayOutputStream
    extends OutputStream {
        protected byte[] buf = null;
        protected int size = 0;

        public FastByteArrayOutputStream() {
            this(5120);
        }

        public FastByteArrayOutputStream(int initSize) {
            this.buf = new byte[initSize];
        }

        private void verifyBufferSize(int sz) {
            if (sz > this.buf.length) {
                byte[] old = this.buf;
                this.buf = new byte[Math.max(sz, 2 * this.buf.length)];
                System.arraycopy(old, 0, this.buf, 0, old.length);
                Object var2_2 = null;
            }
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getByteArray() {
            return this.buf;
        }

        public final void write(byte[] b) {
            this.verifyBufferSize(this.size + b.length);
            System.arraycopy(b, 0, this.buf, this.size, b.length);
            this.size += b.length;
        }

        public final void write(byte[] b, int off, int len) {
            this.verifyBufferSize(this.size + len);
            System.arraycopy(b, off, this.buf, this.size, len);
            this.size += len;
        }

        public final void write(int b) {
            this.verifyBufferSize(this.size + 1);
            this.buf[this.size++] = (byte)b;
        }

        public void reset() {
            this.size = 0;
        }

        public InputStream getInputStream() {
            return new FastByteArrayInputStream(this.buf, this.size);
        }
    }

    class FastByteArrayInputStream
    extends InputStream {
        protected byte[] buf = null;
        protected int count = 0;
        protected int pos = 0;

        public FastByteArrayInputStream(byte[] buf, int count) {
            this.buf = buf;
            this.count = count;
        }

        public final int available() {
            return this.count - this.pos;
        }

        public final int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        public final int read(byte[] b, int off, int len) {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + len > this.count) {
                len = this.count - this.pos;
            }
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public final long skip(long n) {
            if ((long)this.pos + n > (long)this.count) {
                n = this.count - this.pos;
            }
            if (n < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n);
            return n;
        }
    }
}

