/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.bioinformatics.dnaproperties;

import be.abeel.bioinformatics.dnaproperties.DNAProperty;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.NumberFormat;
import java.util.HashMap;

public class RadicalCleavageIntensity
extends DNAProperty {
    private int Nmer;
    private HashMap<String, double[]> mapping;

    protected RadicalCleavageIntensity(int Nmer) {
        super("Radical cleavage intensity (" + Nmer + "-mer)");
        this.Nmer = Nmer;
        this.mapping = new HashMap();
        try {
            URL url = RadicalCleavageIntensity.class.getResource("rci" + Nmer + ".tsv");
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = in.readLine();
            while (line != null) {
                String[] arr = line.split("\t");
                double[] tmp = new double[Nmer];
                for (int i = 1; i <= Nmer; ++i) {
                    tmp[i - 1] = Double.parseDouble(arr[i]);
                }
                this.mapping.put(arr[0].toLowerCase(), tmp);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not construct radical cleavage intensity property");
        }
    }

    public int length() {
        return this.Nmer;
    }

    public double[] normalizedProfile(String seq) {
        return this.profile(seq);
    }

    public double normalizedValue(String seq) {
        return this.value(seq);
    }

    public double[] profile(String seq) {
        int len = seq.length() - this.Nmer + 1;
        double[] values = new double[seq.length()];
        int[] tmp = new int[seq.length()];
        for (int i = 0; i < len; ++i) {
            String sub = seq.substring(i, i + this.Nmer).toLowerCase();
            if (!this.mapping.containsKey(sub)) continue;
            double[] seqVal = this.mapping.get(sub);
            for (int j = 0; j < seqVal.length; ++j) {
                int n = i + j;
                values[n] = values[n] + seqVal[j];
                int n2 = i + j;
                tmp[n2] = tmp[n2] + 1;
            }
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        double div = 1.0;
        for (int i = 0; i < seq.length(); ++i) {
            int n = i;
            values[n] = values[n] / div;
            if (i + 1 < this.Nmer) {
                div += 1.0;
            }
            if (i + this.Nmer < seq.length()) continue;
            div -= 1.0;
        }
        return values;
    }

    public double value(String seq) {
        double value = 0.0;
        int count = 0;
        int len = seq.length() - this.Nmer + 1;
        for (int i = 0; i < len; ++i) {
            double[] seqVal = this.mapping.get(seq.substring(i, i + this.Nmer).toLowerCase());
            if (seqVal == null) {
                return 0.0;
            }
            for (int j = 0; j < seqVal.length; ++j) {
                value += seqVal[j];
                ++count;
            }
        }
        return value /= (double)count;
    }
}

