/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.esa.snap.binning.operator.ui.BinningFormModel;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.SourceProductList;

class BinningIOPanel
extends JPanel {
    private final AppContext appContext;
    private final BinningFormModel binningFormModel;
    private final TargetProductSelector targetProductSelector;
    private SourceProductList sourceProductList;

    BinningIOPanel(AppContext appContext, BinningFormModel binningFormModel, TargetProductSelector targetProductSelector) {
        this.appContext = appContext;
        this.binningFormModel = binningFormModel;
        this.targetProductSelector = targetProductSelector;
        this.init();
    }

    void prepareClose() {
        this.sourceProductList.clear();
    }

    private void init() {
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        tableLayout.setTablePadding(3, 3);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setRowWeightY(0, Double.valueOf(1.0));
        this.add(this.createSourceProductsPanel());
        this.targetProductSelector.getModel().setProductName("level-3");
        this.add(this.targetProductSelector.createDefaultPanel());
    }

    private JPanel createSourceProductsPanel() {
        BorderLayout layout = new BorderLayout();
        JPanel sourceProductPanel = new JPanel(layout);
        sourceProductPanel.setBorder(BorderFactory.createTitledBorder("Source Products"));
        ListDataListener changeListener = new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent event) {
                Product[] sourceProducts = BinningIOPanel.this.sourceProductList.getSourceProducts();
                try {
                    BinningIOPanel.this.binningFormModel.setProperty("sourceProducts", sourceProducts);
                }
                catch (ValidationException e) {
                    BinningIOPanel.this.appContext.handleError("Unable to set source products.", (Throwable)e);
                }
                if (sourceProducts.length > 0) {
                    BinningIOPanel.this.binningFormModel.useAsContextProduct(sourceProducts[0]);
                    return;
                }
                String[] sourceProductPaths = BinningIOPanel.this.binningFormModel.getSourceProductPaths();
                if (sourceProductPaths != null && sourceProductPaths.length > 0) {
                    BinningIOPanel.this.openFirstProduct(sourceProductPaths);
                    return;
                }
                BinningIOPanel.this.binningFormModel.useAsContextProduct(null);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }
        };
        this.sourceProductList = new SourceProductList(this.appContext);
        this.sourceProductList.setPropertyNameLastOpenInputDir("org.esa.snap.binning.lastDir");
        this.sourceProductList.setPropertyNameLastOpenedFormat("org.esa.snap.binning.lastFormat");
        this.sourceProductList.addChangeListener(changeListener);
        this.sourceProductList.setXAxis(false);
        this.binningFormModel.getBindingContext().bind("sourceProductPaths", (ComponentAdapter)this.sourceProductList);
        JComboBox sourceFormatComboBox = new JComboBox();
        this.binningFormModel.getBindingContext().bind("sourceProductFormat", sourceFormatComboBox);
        JLabel formatLabel = new JLabel("Source format:");
        TableLayout formatLayout = new TableLayout(2);
        formatLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        formatLayout.setTablePadding(new Insets(4, 10, 0, 0));
        formatLayout.setTableFill(TableLayout.Fill.BOTH);
        formatLayout.setColumnWeightX(1, Double.valueOf(2.0));
        JPanel formatPanel = new JPanel((LayoutManager)formatLayout);
        formatPanel.add(formatLabel);
        formatPanel.add(sourceFormatComboBox);
        JComponent[] panels = this.sourceProductList.getComponents();
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)panels[0], "Center");
        listPanel.add((Component)formatPanel, "South");
        sourceProductPanel.add((Component)listPanel, "Center");
        sourceProductPanel.add((Component)panels[1], "East");
        return sourceProductPanel;
    }

    private void openFirstProduct(final String[] inputPaths) {
        SwingWorker<Product, Void> worker = new SwingWorker<Product, Void>(){

            @Override
            protected Product doInBackground() throws Exception {
                for (String inputPath : inputPaths) {
                    if (inputPath == null || inputPath.trim().length() == 0) continue;
                    try {
                        TreeSet fileSet = new TreeSet();
                        WildcardMatcher.glob((String)inputPath, fileSet);
                        for (File file : fileSet) {
                            Product product = ProductIO.readProduct((File)file);
                            if (product == null) continue;
                            return product;
                        }
                    }
                    catch (IOException e) {
                        Logger logger = SystemUtils.LOG;
                        logger.severe("I/O problem occurred while scanning source product files: " + e.getMessage());
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    Product firstProduct = (Product)this.get();
                    if (firstProduct != null) {
                        BinningIOPanel.this.binningFormModel.useAsContextProduct(firstProduct);
                        firstProduct.dispose();
                    }
                }
                catch (Exception ex) {
                    String msg = String.format("Cannot open source products.\n%s", ex.getMessage());
                    BinningIOPanel.this.appContext.handleError(msg, (Throwable)ex);
                }
            }
        };
        worker.execute();
    }
}

