/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.TypedDescriptorsRegistry;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.binning.operator.ui.AggregatorTableController;
import org.esa.snap.binning.operator.ui.BinningConfigurationPanel;
import org.esa.snap.binning.operator.ui.BinningForm;
import org.esa.snap.binning.operator.ui.BinningFormModel;
import org.esa.snap.binning.operator.ui.VariableTableController;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.ParameterUpdater;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.ui.AppContext;

public class BinningDialog
extends SingleTargetProductDialog {
    private static final String OPERATOR_NAME = "Binning";
    private final BinningForm form;
    private final BinningFormModel formModel = new BinningFormModel();

    protected BinningDialog(AppContext appContext, String title, String helpID) {
        super(appContext, title, 152, helpID, new TargetProductSelectorModel(), true);
        this.form = new BinningForm(appContext, this.formModel, this.getTargetProductSelector());
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(OPERATOR_NAME);
        BinningParameterUpdater parameterUpdater = new BinningParameterUpdater();
        OperatorParameterSupport parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor(), this.formModel.getPropertySet(), this.formModel.getParameterMap(), (ParameterUpdater)parameterUpdater);
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), operatorSpi.getOperatorDescriptor(), parameterSupport, appContext, helpID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
    }

    protected boolean verifyUserInput() {
        AggregatorConfig[] aggregatorConfigs = this.formModel.getAggregatorConfigs();
        if (!this.isAtLeastOneAggreatorConfigDefined(aggregatorConfigs)) {
            return false;
        }
        if (!this.doUsedVariablesStillExist(aggregatorConfigs)) {
            return false;
        }
        if (!this.areTargetNamesUnique(aggregatorConfigs)) {
            return false;
        }
        return this.isTimeFilterWellConfigured();
    }

    protected Product createTargetProduct() throws Exception {
        TargetProductCreator targetProductCreator = new TargetProductCreator();
        targetProductCreator.executeWithBlocking();
        return (Product)targetProductCreator.get();
    }

    public int show() {
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareClose();
        super.hide();
    }

    private boolean doUsedVariablesStillExist(AggregatorConfig[] aggregatorConfigs) {
        Product contextProduct = this.formModel.getContextProduct();
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        for (AggregatorConfig aggregatorConfig : aggregatorConfigs) {
            String[] sourceVarNames;
            String aggregatorConfigName = aggregatorConfig.getName();
            AggregatorDescriptor descriptor = (AggregatorDescriptor)registry.getDescriptor(AggregatorDescriptor.class, aggregatorConfigName);
            for (String sourceVarName : sourceVarNames = descriptor.getSourceVarNames(aggregatorConfig)) {
                if (!Objects.isNull(contextProduct) && contextProduct.containsBand(sourceVarName)) continue;
                String msg = String.format("Source band name '%s' of aggregator '%s' is unknown.\nIt is neither one of the bands of the source products,\nnor is it defined by an intermediate source band.", sourceVarName, aggregatorConfigName);
                this.showErrorDialog(msg);
                return false;
            }
        }
        return true;
    }

    private boolean isTimeFilterWellConfigured() {
        if (this.formModel.getTimeFilterMethod() == BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY || this.formModel.getTimeFilterMethod() == BinningOp.TimeFilterMethod.TIME_RANGE) {
            if (this.formModel.getStartDateTime() == null) {
                this.showErrorDialog("Start date/time must be provided when time filter method 'spatiotemporal data day' or 'time range' is chosen.");
                return false;
            }
            if (this.formModel.getPeriodDuration() == null) {
                this.showErrorDialog("Period duration must be provided when time filter method 'spatiotemporal data day' or 'time range' is chosen.");
                return false;
            }
        }
        if (this.formModel.getTimeFilterMethod() == BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY && this.formModel.getMinDataHour() == null) {
            this.showErrorDialog("Min data hour must be provided when time filter method 'spatiotemporal data day' is chosen.");
            return false;
        }
        return true;
    }

    private boolean isAtLeastOneAggreatorConfigDefined(AggregatorConfig[] aggregatorConfigs) {
        if (aggregatorConfigs.length == 0) {
            this.showErrorDialog("Please configure at least a single aggregator.");
            return false;
        }
        return true;
    }

    private boolean areTargetNamesUnique(AggregatorConfig[] aggregatorConfigs) {
        ArrayList<String> targetVarNameList = new ArrayList<String>();
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        for (AggregatorConfig aggregatorConfig : aggregatorConfigs) {
            String[] targetNames;
            AggregatorDescriptor descriptor = (AggregatorDescriptor)registry.getDescriptor(AggregatorDescriptor.class, aggregatorConfig.getName());
            for (String targetName : targetNames = descriptor.getTargetVarNames(aggregatorConfig)) {
                if (targetVarNameList.contains(targetName)) {
                    this.showErrorDialog(String.format("The target band with the name '%s' is defined twice.", targetName));
                    return false;
                }
                targetVarNameList.add(targetName);
            }
        }
        return true;
    }

    private void updateParameterMap(Map<String, Object> parameters) {
        parameters.put("variableConfigs", this.formModel.getVariableConfigs());
        parameters.put("aggregatorConfigs", this.formModel.getAggregatorConfigs());
        parameters.put("outputFile", this.getTargetProductSelector().getModel().getProductFile().getPath());
        parameters.put("maskExpr", this.formModel.getMaskExpr());
        parameters.put("region", this.formModel.getRegion());
        parameters.put("numRows", this.formModel.getNumRows());
        parameters.put("superSampling", this.formModel.getSuperSampling());
        parameters.put("sourceProductFormat", this.formModel.getSourceProductFormat());
        parameters.put("sourceProductPaths", this.formModel.getSourceProductPaths());
        BinningOp.TimeFilterMethod method = this.formModel.getTimeFilterMethod();
        parameters.put("timeFilterMethod", method);
        if (method == BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY) {
            parameters.put("minDataHour", this.formModel.getMinDataHour());
            parameters.put("startDateTime", this.formModel.getStartDateTime());
            parameters.put("periodDuration", this.formModel.getPeriodDuration());
        } else if (method == BinningOp.TimeFilterMethod.TIME_RANGE) {
            parameters.put("startDateTime", this.formModel.getStartDateTime());
            parameters.put("periodDuration", this.formModel.getPeriodDuration());
        }
    }

    private void updateFormModel(Map<String, Object> parameterMap) throws ValidationException {
        PropertySet propertySet = this.formModel.getBindingContext().getPropertySet();
        Set<Map.Entry<String, Object>> entries = parameterMap.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            Property property = propertySet.getProperty(entry.getKey());
            if (property == null) continue;
            property.setValue(entry.getValue());
        }
        if (parameterMap.containsKey("outputFile")) {
            File outputFile = new File((String)parameterMap.get("outputFile"));
            File outputDir = outputFile.getParentFile();
            if (outputDir != null) {
                this.getTargetProductSelector().getModel().setProductDir(outputDir);
            }
            this.getTargetProductSelector().getModel().setProductName(FileUtils.getFilenameWithoutExtension((File)outputFile));
        }
        BinningConfigurationPanel configurationPanel = this.form.getBinningConfigurationPanel();
        VariableTableController variableTableController = configurationPanel.getVariableTableController();
        VariableConfig[] variableConfigs = new VariableConfig[]{};
        if (parameterMap.containsKey("variableConfigs")) {
            variableConfigs = (VariableConfig[])parameterMap.get("variableConfigs");
        }
        variableTableController.setVariableConfigs(variableConfigs);
        AggregatorTableController aggregatorTableController = configurationPanel.getAggregatorTableController();
        AggregatorConfig[] aggregatorConfigs = new AggregatorConfig[]{};
        if (parameterMap.containsKey("aggregatorConfigs")) {
            aggregatorConfigs = (AggregatorConfig[])parameterMap.get("aggregatorConfigs");
        }
        aggregatorTableController.setAggregatorConfigs(aggregatorConfigs);
    }

    private class BinningParameterUpdater
    implements ParameterUpdater {
        private BinningParameterUpdater() {
        }

        public void handleParameterSaveRequest(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
            BinningDialog.this.formModel.getBindingContext().adjustComponents();
            BinningDialog.this.updateParameterMap(parameterMap);
        }

        public void handleParameterLoadRequest(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
            BinningDialog.this.updateFormModel(parameterMap);
            BinningDialog.this.formModel.getBindingContext().adjustComponents();
        }
    }

    private class TargetProductCreator
    extends ProgressMonitorSwingWorker<Product, Void> {
        protected TargetProductCreator() {
            super((Component)BinningDialog.this.getJDialog(), "Creating target product");
        }

        protected Product doInBackground(ProgressMonitor pm) throws Exception {
            pm.beginTask("Binning...", 100);
            HashMap parameters = new HashMap();
            BinningDialog.this.updateParameterMap(parameters);
            Product targetProduct = GPF.createProduct((String)BinningDialog.OPERATOR_NAME, parameters, (Product[])BinningDialog.this.formModel.getSourceProducts());
            pm.done();
            return targetProduct;
        }
    }
}

