/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.swing.Grid;
import com.bc.ceres.swing.ListControlBar;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.esa.snap.binning.operator.ui.AggregatorTableController;
import org.esa.snap.binning.operator.ui.BinningFormModel;
import org.esa.snap.binning.operator.ui.VariableTableController;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductExpressionPane;
import org.esa.snap.ui.tool.ToolButtonFactory;

class BinningConfigurationPanel
extends JPanel {
    private final AppContext appContext;
    private final BinningFormModel binningFormModel;
    private double currentGridResolution;
    private AggregatorTableController aggregatorTableController;
    private VariableTableController variableTableController;

    BinningConfigurationPanel(AppContext appContext, BinningFormModel binningFormModel) {
        this.appContext = appContext;
        this.binningFormModel = binningFormModel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createAggregatorsAndVariablesPanel(), "Center");
        this.add((Component)this.createParametersPanel(), "South");
    }

    VariableTableController getVariableTableController() {
        return this.variableTableController;
    }

    AggregatorTableController getAggregatorTableController() {
        return this.aggregatorTableController;
    }

    private JComponent createAggregatorsAndVariablesPanel() {
        JideSplitPane splitPane = new JideSplitPane(0);
        splitPane.add((Component)this.createAggregatorsPanel());
        splitPane.add((Component)this.createVariablesPanel());
        splitPane.setShowGripper(true);
        splitPane.setProportionalLayout(true);
        splitPane.setProportions(new double[]{0.6});
        return splitPane;
    }

    private JPanel createParametersPanel() {
        BindingContext bindingContext = this.binningFormModel.getBindingContext();
        JLabel validPixelExpressionLabel = new JLabel("Valid-pixel expression:");
        final JButton validPixelExpressionButton = new JButton("...");
        Dimension preferredSize = validPixelExpressionButton.getPreferredSize();
        preferredSize.setSize(25.0, preferredSize.getHeight());
        validPixelExpressionButton.setPreferredSize(preferredSize);
        validPixelExpressionButton.setEnabled(this.hasSourceProducts());
        this.binningFormModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("contextSourceProduct")) {
                    validPixelExpressionButton.setEnabled(BinningConfigurationPanel.this.hasSourceProducts());
                }
            }
        });
        JLabel targetHeightLabel = new JLabel("#Rows (90N - 90S):");
        final JTextField validPixelExpressionField = new JTextField();
        bindingContext.bind("maskExpr", validPixelExpressionField);
        validPixelExpressionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String expression = BinningConfigurationPanel.this.editExpression(validPixelExpressionField.getText());
                if (expression != null) {
                    try {
                        BinningConfigurationPanel.this.binningFormModel.setProperty("maskExpr", expression);
                    }
                    catch (ValidationException e) {
                        BinningConfigurationPanel.this.appContext.handleError("Invalid expression", (Throwable)e);
                    }
                }
            }
        });
        final IntegerTextField numRowsTextField = new IntegerTextField(2160);
        JLabel resolutionLabel = new JLabel("Spatial resolution (km/px):");
        final String defaultResolution = BinningConfigurationPanel.getString(BinningConfigurationPanel.computeResolution(2160));
        final DoubleTextField resolutionTextField = new DoubleTextField(defaultResolution);
        JButton resolutionButton = new JButton("default");
        JLabel superSamplingLabel = new JLabel("Super-sampling:");
        IntegerTextField superSamplingTextField = new IntegerTextField(1);
        final ResolutionTextFieldListener listener = new ResolutionTextFieldListener(resolutionTextField, numRowsTextField);
        bindingContext.bind("numRows", (JTextField)numRowsTextField);
        bindingContext.bind("superSampling", (JTextField)superSamplingTextField);
        bindingContext.getBinding("numRows").setPropertyValue((Object)2160);
        bindingContext.getBinding("superSampling").setPropertyValue((Object)1);
        bindingContext.getPropertySet().getProperty("numRows").addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BinningConfigurationPanel.updateResolutionLabel(numRowsTextField, resolutionTextField, listener);
            }
        });
        resolutionTextField.addFocusListener(listener);
        resolutionTextField.addActionListener(listener);
        resolutionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                resolutionTextField.setText(defaultResolution);
                listener.update();
            }
        });
        validPixelExpressionLabel.setToolTipText("Only those pixels matching this expression are considered");
        targetHeightLabel.setToolTipText("<html>The number of rows of the <b>maximum</b> target grid</html>");
        resolutionLabel.setToolTipText("The spatial resolution, directly depending on #rows");
        superSamplingLabel.setToolTipText("Every input pixel is subdivided into n x n sub-pixels in order to reduce or avoid the Moir\u00e9 effect");
        TableLayout layout = new TableLayout(3);
        layout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        layout.setTableWeightX(Double.valueOf(0.0));
        layout.setCellColspan(1, 1, Integer.valueOf(2));
        layout.setCellColspan(3, 1, Integer.valueOf(2));
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setColumnWeightX(1, Double.valueOf(1.0));
        layout.setTablePadding(10, 5);
        JPanel parametersPanel = new JPanel((LayoutManager)layout);
        parametersPanel.add(validPixelExpressionLabel);
        parametersPanel.add(validPixelExpressionField);
        parametersPanel.add(validPixelExpressionButton);
        parametersPanel.add(targetHeightLabel);
        parametersPanel.add(numRowsTextField);
        parametersPanel.add(resolutionLabel);
        parametersPanel.add(resolutionTextField);
        parametersPanel.add(resolutionButton);
        parametersPanel.add(superSamplingLabel);
        parametersPanel.add(superSamplingTextField);
        return parametersPanel;
    }

    private static int computeNumRows(double resolution) {
        double RE = 6378.145;
        int numRows = (int)(20037.533475530472 / resolution) + 1;
        return numRows % 2 == 0 ? numRows : numRows + 1;
    }

    private static double computeResolution(int numRows) {
        double RE = 6378.145;
        return 20037.533475530472 / (double)(numRows - 1);
    }

    private static void updateResolutionLabel(JTextField targetHeightTextField, JTextField resolutionField, ResolutionTextFieldListener listener) {
        resolutionField.setText(BinningConfigurationPanel.getResolutionString(Integer.parseInt(targetHeightTextField.getText())));
        listener.update();
    }

    static String getResolutionString(int numRows) {
        double number = BinningConfigurationPanel.computeResolution(numRows);
        return BinningConfigurationPanel.getString(number);
    }

    private static String getString(double number) {
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#.##", formatSymbols);
        return decimalFormat.format(number);
    }

    private boolean hasSourceProducts() {
        return this.binningFormModel.getContextProduct() != null;
    }

    private String editExpression(String expression) {
        Product product = this.binningFormModel.getContextProduct();
        if (product == null) {
            return null;
        }
        ProductExpressionPane expressionPane = ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{product}, (Product)product, (PropertyMap)this.appContext.getPreferences());
        expressionPane.setCode(expression);
        int i = expressionPane.showModalDialog(this.appContext.getApplicationWindow(), "Expression Editor");
        if (i == 1) {
            return expressionPane.getCode();
        }
        return null;
    }

    private JPanel createAggregatorsPanel() {
        final Grid grid = new Grid(6, false);
        TableLayout gridLayout = grid.getLayout();
        gridLayout.setTablePadding(4, 3);
        gridLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        gridLayout.setColumnFill(2, TableLayout.Fill.HORIZONTAL);
        gridLayout.setColumnFill(3, TableLayout.Fill.HORIZONTAL);
        gridLayout.setColumnFill(4, TableLayout.Fill.HORIZONTAL);
        gridLayout.setColumnWeightX(2, Double.valueOf(1.0));
        gridLayout.setColumnWeightX(3, Double.valueOf(1.0));
        gridLayout.setColumnWeightX(4, Double.valueOf(1.0));
        grid.setHeaderRow(new JComponent[]{new JLabel("<html><b>Aggregator</b>"), new JLabel("<html><b>Source Bands</b>"), new JLabel("<html><b>Parameters</b>"), new JLabel("<html><b>Target Bands</b>"), null});
        this.aggregatorTableController = new AggregatorTableController(grid, this.binningFormModel);
        final ListControlBar gridControlBar = ListControlBar.create((int)0, (Grid)grid, (ListControlBar.ListController)this.aggregatorTableController, (String[])new String[0]);
        final AbstractButton sel = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ShowSelection16.png"), (boolean)true);
        sel.setToolTipText("Show/hide selection column");
        sel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                grid.setShowSelectionColumn(sel.isSelected());
                gridControlBar.updateState();
            }
        });
        gridControlBar.add((Component)sel, 0);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)gridControlBar, "North");
        panel.add((Component)new JScrollPane((Component)grid), "Center");
        return panel;
    }

    private JPanel createVariablesPanel() {
        final Grid grid = new Grid(5, false);
        TableLayout gridLayout = grid.getLayout();
        gridLayout.setTablePadding(4, 3);
        gridLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        gridLayout.setColumnFill(2, TableLayout.Fill.HORIZONTAL);
        gridLayout.setColumnWeightX(2, Double.valueOf(1.0));
        grid.setHeaderRow(new JComponent[]{new JLabel("<html><b>Name</b>"), new JLabel("<html><b>Expression</b>"), new JLabel("<html><b>Valid-Pixel Expression</b>"), null});
        this.variableTableController = new VariableTableController(grid, this.binningFormModel);
        final ListControlBar gridControlBar = ListControlBar.create((int)0, (Grid)grid, (ListControlBar.ListController)this.variableTableController, (String[])new String[0]);
        final AbstractButton sel = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/ShowSelection16.png"), (boolean)true);
        sel.setToolTipText("Show/hide selection column");
        sel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                grid.setShowSelectionColumn(sel.isSelected());
                gridControlBar.updateState();
            }
        });
        gridControlBar.add((Component)sel, 0);
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new TitledBorder("Intermediate Source Bands (optional)"));
        panel.add((Component)gridControlBar, "North");
        panel.add((Component)new JScrollPane((Component)grid), "Center");
        return panel;
    }

    private class ResolutionTextFieldListener
    extends FocusAdapter
    implements ActionListener {
        private final JTextField resolutionTextField;
        private final JTextField numRowsTextField;

        public ResolutionTextFieldListener(JTextField resolutionTextField, JTextField numRowsTextField) {
            this.resolutionTextField = resolutionTextField;
            this.numRowsTextField = numRowsTextField;
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        private void update() {
            double resolution = Double.parseDouble(this.resolutionTextField.getText());
            if (Math.abs(BinningConfigurationPanel.this.currentGridResolution - resolution) > 1.0E-6) {
                BinningConfigurationPanel.this.binningFormModel.getBindingContext().getPropertySet().setValue("numRows", (Object)BinningConfigurationPanel.computeNumRows(resolution));
                this.numRowsTextField.setText(String.valueOf(BinningConfigurationPanel.computeNumRows(resolution)));
                BinningConfigurationPanel.this.currentGridResolution = resolution;
            }
        }
    }

    private class DoubleTextField
    extends JTextField {
        private static final String disallowedChars = "`\u00a7~!@#$%^&*()_+=\\|\"':;?/><,- ";

        public DoubleTextField(String defaultValue) {
            super(defaultValue);
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (!Character.isLetter(e.getKeyChar()) && disallowedChars.indexOf(e.getKeyChar()) == -1) {
                super.processKeyEvent(e);
            }
        }
    }

    private static class IntegerTextField
    extends JTextField {
        private static final String disallowedChars = "`\u00a7~!@#$%^&*()_+=\\|\"':;?/>.<,- ";

        public IntegerTextField(int defaultValue) {
            super(defaultValue + "");
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (!Character.isLetter(e.getKeyChar()) && disallowedChars.indexOf(e.getKeyChar()) == -1) {
                super.processKeyEvent(e);
            }
        }
    }
}

