/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.TypedDescriptor;
import org.esa.snap.binning.TypedDescriptorsRegistry;
import org.esa.snap.binning.operator.ui.AggregatorItem;
import org.esa.snap.binning.operator.ui.AggregatorTableController;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.ui.ModalDialog;

class AggregatorItemDialog
extends ModalDialog {
    private final AggregatorItem aggregatorItem;
    private final String[] sourceVarNames;
    private AggregatorConfig aggregatorConfig;
    private AggregatorDescriptor aggregatorDescriptor;
    private PropertySet aggregatorPropertySet;
    private JComboBox<String> aggregatorComboBox;

    public AggregatorItemDialog(Window parent, String[] sourceVarNames, AggregatorItem aggregatorItem, boolean initWithDefaults) {
        super(parent, "Edit Aggregator", 33, null);
        this.sourceVarNames = sourceVarNames;
        this.aggregatorItem = aggregatorItem;
        this.aggregatorConfig = aggregatorItem.aggregatorConfig;
        this.aggregatorDescriptor = aggregatorItem.aggregatorDescriptor;
        this.aggregatorPropertySet = this.createPropertySet(this.aggregatorConfig);
        if (initWithDefaults) {
            this.aggregatorPropertySet.setDefaultValues();
        } else {
            Property[] objectProperties;
            PropertyContainer objectPropertySet = PropertyContainer.createObjectBacked((Object)this.aggregatorConfig);
            for (Property objectProperty : objectProperties = objectPropertySet.getProperties()) {
                this.aggregatorPropertySet.setValue(objectProperty.getName(), objectProperty.getValue());
            }
        }
    }

    public int show() {
        this.setContent(this.createUI());
        this.getJDialog().getRootPane().registerKeyboardAction(e -> this.close(), KeyStroke.getKeyStroke(27, 0), 2);
        this.getJDialog().setResizable(false);
        return super.show();
    }

    protected boolean verifyUserInput() {
        try {
            for (Property property : this.aggregatorPropertySet.getProperties()) {
                property.validate(property.getValue());
            }
        }
        catch (ValidationException e) {
            this.showErrorDialog(e.getMessage(), "Invalid Aggregator Properties");
            return false;
        }
        return true;
    }

    protected void onOK() {
        Property[] mapProperties;
        AggregatorConfig config = (AggregatorConfig)this.aggregatorDescriptor.createConfig();
        PropertySet objectPropertySet = config.asPropertySet();
        for (Property mapProperty : mapProperties = this.aggregatorPropertySet.getProperties()) {
            objectPropertySet.setValue(mapProperty.getName(), mapProperty.getValue());
        }
        objectPropertySet.setValue("type", (Object)this.aggregatorDescriptor.getName());
        this.aggregatorItem.aggregatorConfig = config;
        this.aggregatorItem.aggregatorDescriptor = this.aggregatorDescriptor;
        super.onOK();
    }

    private Component createUI() {
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        List aggregatorDescriptors = registry.getDescriptors(AggregatorDescriptor.class);
        List<String> aggregatorNames = aggregatorDescriptors.stream().map(TypedDescriptor::getName).collect(Collectors.toList());
        Collections.sort(aggregatorNames);
        this.aggregatorComboBox = new JComboBox<String>(aggregatorNames.toArray(new String[aggregatorNames.size()]));
        this.aggregatorComboBox.setSelectedItem(this.aggregatorConfig.getName());
        this.aggregatorComboBox.addActionListener(e -> {
            this.aggregatorDescriptor = this.getDescriptorFromComboBox();
            this.aggregatorConfig = (AggregatorConfig)this.aggregatorDescriptor.createConfig();
            this.aggregatorPropertySet = this.createPropertySet(this.aggregatorConfig);
            JPanel aggrPropertyPanel = this.createPropertyPanel(this.aggregatorPropertySet);
            mainPanel.remove(1);
            mainPanel.add((Component)aggrPropertyPanel, "Center");
            this.getJDialog().getContentPane().revalidate();
            this.getJDialog().pack();
        });
        JPanel aggrPropertyPanel = this.createPropertyPanel(this.aggregatorPropertySet);
        mainPanel.add(this.aggregatorComboBox, "North");
        mainPanel.add((Component)aggrPropertyPanel, "Center");
        return mainPanel;
    }

    private PropertySet createPropertySet(AggregatorConfig config) {
        return PropertyContainer.createMapBacked(new HashMap(), config.getClass(), (PropertyDescriptorFactory)new ParameterDescriptorFactory());
    }

    private AggregatorDescriptor getDescriptorFromComboBox() {
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        String aggrType = (String)this.aggregatorComboBox.getSelectedItem();
        return (AggregatorDescriptor)registry.getDescriptor(AggregatorDescriptor.class, aggrType);
    }

    private JPanel createPropertyPanel(PropertySet propertySet) {
        Property[] properties;
        for (Property property : properties = propertySet.getProperties()) {
            String propertyName = property.getName();
            if ("type".equals(propertyName)) {
                property.getDescriptor().setAttribute("visible", (Object)false);
            }
            if (!AggregatorTableController.isSourcePropertyName(propertyName)) continue;
            property.getDescriptor().setValueSet(new ValueSet((Object[])this.sourceVarNames));
        }
        return new PropertyPane(propertySet).createPanel();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame();
            jFrame.setDefaultCloseOperation(3);
            JButton aggregatorComboBox1 = new JButton("Show Dialog...");
            aggregatorComboBox1.addActionListener(e -> {
                AggregatorItemDialog dialog1 = new AggregatorItemDialog(jFrame, new String[]{"stein", "papier", "schere", "echse", "spock"}, new AggregatorItem(), true);
                dialog1.getJDialog().setLocation(550, 300);
                dialog1.show();
            });
            jFrame.setContentPane(aggregatorComboBox1);
            jFrame.setBounds(300, 300, 200, 80);
            jFrame.setVisible(true);
        });
    }
}

