/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider.DataProvider;

public class PropertiesProvider
implements DataProvider {
    private final DecimalFormat df = new DecimalFormat("#.##");
    private final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"dd-MMM-yyyy");
    private static final String[] propertyLabels = new String[]{"File:", "Name:", "Type:", "Acquired:", "File Format:"};
    private final Comparator productPropertiesComparator;
    private TableColumn propertiesColumn;
    private final boolean minimalView;

    public PropertiesProvider(boolean minimalView) {
        this.minimalView = minimalView;
        this.productPropertiesComparator = new ProductPropertiesComparator();
    }

    @Override
    public Comparator getComparator() {
        return this.productPropertiesComparator;
    }

    public void cleanUp(ProductEntry entry) {
    }

    @Override
    public TableColumn getTableColumn() {
        if (this.propertiesColumn == null) {
            try {
                this.propertiesColumn = new TableColumn();
                this.propertiesColumn.setResizable(true);
                this.propertiesColumn.setPreferredWidth(250);
                this.propertiesColumn.setHeaderValue("Product Properties");
                this.propertiesColumn.setCellRenderer(new ProductPropertiesRenderer());
            }
            catch (Throwable e) {
                SystemUtils.LOG.severe("PropertiesProvider: " + e.getMessage());
            }
        }
        return this.propertiesColumn;
    }

    private static class ProductPropertiesComparator
    implements Comparator {
        private ProductPropertiesComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ProductEntry s1 = (ProductEntry)o1;
            ProductEntry s2 = (ProductEntry)o2;
            return s1.getName().compareTo(s2.getName());
        }
    }

    private class ProductPropertiesRenderer
    extends JTable
    implements TableCellRenderer {
        private final int ROW_HEIGHT;
        private final JPanel centeringPanel;
        private final Font valueFont;
        private final Font boldFont;

        public ProductPropertiesRenderer() {
            this.ROW_HEIGHT = PropertiesProvider.this.minimalView ? 34 : 68;
            this.centeringPanel = new JPanel(new BorderLayout());
            DefaultTableModel dataModel = new DefaultTableModel();
            dataModel.setColumnCount(1);
            this.setRowHeight(14);
            dataModel.setRowCount(propertyLabels.length);
            this.setModel(dataModel);
            this.valueFont = this.getFont().deriveFont(0, 12.0f);
            this.boldFont = this.valueFont.deriveFont(1);
            this.getColumnModel().getColumn(0).setCellRenderer(new PropertyValueCellRenderer(this.valueFont, this.boldFont));
            this.getTableHeader().setVisible(false);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                Color foregroundColor;
                Color backgroundColor;
                String[] values = null;
                String toolTip = "";
                if (value instanceof ProductEntry) {
                    ProductEntry entry = (ProductEntry)value;
                    String pixelSpacing = "";
                    if (entry.getRangeSpacing() > 0.0 && entry.getAzimuthSpacing() > 0.0) {
                        pixelSpacing = PropertiesProvider.this.df.format(entry.getRangeSpacing()) + " x " + PropertiesProvider.this.df.format(entry.getAzimuthSpacing()) + " m";
                    }
                    File file = entry.getFile();
                    String fileSize = entry.getFileSizeString() == null ? "(" + entry.getFileSize() / 0x100000L + " MB)" : "(" + entry.getFileSizeString() + ")";
                    String dateString = PropertiesProvider.this.dateFormat.format(entry.getFirstLineTime().getAsDate());
                    String polStr = "";
                    MetadataElement absRoot = entry.getMetadata();
                    if (absRoot != null) {
                        String pol1 = absRoot.getAttributeString("mds1_tx_rx_polar");
                        String pol2 = absRoot.getAttributeString("mds2_tx_rx_polar");
                        String pol3 = absRoot.getAttributeString("mds3_tx_rx_polar");
                        String pol4 = absRoot.getAttributeString("mds4_tx_rx_polar");
                        polStr = pol1;
                        if (!pol2.equals("-")) {
                            polStr = polStr + ' ' + pol2;
                        }
                        if (!pol3.equals("-")) {
                            polStr = polStr + ' ' + pol3;
                        }
                        if (!pol4.equals("-")) {
                            polStr = polStr + ' ' + pol4;
                        }
                    } else {
                        polStr = entry.getAcquisitionMode();
                    }
                    values = PropertiesProvider.this.minimalView ? new String[]{entry.getName(), entry.getMission() + "   " + entry.getProductType() + "   " + entry.getPass() + "  " + polStr + "   " + dateString + "   " + pixelSpacing} : (file != null ? new String[]{file.getName(), entry.getName(), entry.getMission() + "   " + entry.getProductType() + "   " + entry.getPass() + "  " + polStr, dateString + "   " + pixelSpacing, entry.getFileFormat() + "   " + fileSize} : new String[]{entry.getName(), entry.getMission() + "   " + entry.getProductType() + "   " + entry.getPass() + "  " + polStr, dateString + "   " + pixelSpacing, entry.getFileFormat() + "   " + fileSize});
                    for (int i = 0; i < values.length; ++i) {
                        this.setValueAt(values[i], i, 0);
                    }
                    if (file != null) {
                        toolTip = file.getAbsolutePath();
                    }
                } else if (value == null) {
                    for (int i = 0; i < propertyLabels.length; ++i) {
                        this.setValueAt(null, i, 0);
                    }
                }
                if (isSelected) {
                    backgroundColor = table.getSelectionBackground();
                    foregroundColor = table.getSelectionForeground();
                } else {
                    backgroundColor = table.getBackground();
                    foregroundColor = table.getForeground();
                }
                this.setForeground(foregroundColor);
                this.setBackground(backgroundColor);
                this.centeringPanel.setForeground(foregroundColor);
                this.centeringPanel.setBackground(backgroundColor);
                this.centeringPanel.setBorder(BorderFactory.createLineBorder(backgroundColor, 3));
                this.centeringPanel.add((Component)this, "Center");
                this.centeringPanel.setToolTipText(toolTip);
                this.adjustCellSize(table, row, column, values);
            }
            catch (Throwable e) {
                SystemUtils.LOG.severe("ProductPropertiesRenderer: " + e.getMessage());
            }
            return this.centeringPanel;
        }

        private void adjustCellSize(JTable table, int row, int column, String[] values) {
            this.setRowHeight(table, row, this.ROW_HEIGHT);
            int labelsLength = this.getMaxStringLength(propertyLabels, this.getFontMetrics(this.getFont()));
            int valuesLength = 50;
            if (values != null) {
                valuesLength = Math.min(200, this.getMaxStringLength(values, this.getFontMetrics(this.valueFont)));
            }
            int preferredWidth = labelsLength + valuesLength;
            TableColumn valueColumn = table.getColumnModel().getColumn(column);
            int valueColWidth = Math.max(valueColumn.getWidth(), preferredWidth);
            this.increasePreferredColumnWidth(valueColumn, valueColWidth);
        }

        private void increasePreferredColumnWidth(TableColumn column, int length) {
            if (column.getPreferredWidth() < length) {
                column.setPreferredWidth(length);
            }
        }

        private void setRowHeight(JTable table, int row, int rowHeight) {
            int currentRowHeight = table.getRowHeight(row);
            if (currentRowHeight < rowHeight) {
                table.setRowHeight(rowHeight);
            }
        }

        private int getMaxStringLength(String[] strings, FontMetrics fontMetrics) {
            int maxWidth = Integer.MIN_VALUE;
            for (String string : strings) {
                if (string == null) continue;
                int width = SwingUtilities.computeStringWidth(fontMetrics, string);
                maxWidth = Math.max(width, maxWidth);
            }
            return maxWidth;
        }

        private class PropertyValueCellRenderer
        extends DefaultTableCellRenderer {
            private final Font font;
            private final Font boldFont;

            public PropertyValueCellRenderer(Font font, Font boldFont) {
                this.font = font;
                this.boldFont = boldFont;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                try {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (jLabel != null) {
                        jLabel.setHorizontalAlignment(2);
                        if (row == 0 && column == 0) {
                            jLabel.setFont(this.boldFont);
                        } else {
                            jLabel.setFont(this.font);
                        }
                        return jLabel;
                    }
                }
                catch (Throwable e) {
                    SystemUtils.LOG.severe("PropertyValueCellRenderer: " + e.getMessage());
                }
                return null;
            }
        }
    }
}

