/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.ProgressMonitor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ListView;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ProductEntryList;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ProductEntryTable;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ThumbnailView;
import org.esa.snap.rcp.quicklooks.ThumbnailPanel;
import org.esa.snap.ui.UIUtils;

public class ViewActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon listViewButtonIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_list24.png", ThumbnailPanel.class);
    private static final ImageIcon tableViewButtonIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_table24.png", ThumbnailPanel.class);
    private static final ImageIcon thumbnailViewButtonIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/rcp/icons/view_thumbnails24.png", ThumbnailPanel.class);
    private JButton button = null;
    private ProductLibraryActions actionHandler;

    @Override
    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"viewButton", (String)"Change View", (ImageIcon)tableViewButtonIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        }
        return this.button;
    }

    @Override
    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(true);
    }

    @Override
    public void performAction(ProgressMonitor pm) {
        this.actionHandler.getToolView().changeView();
        ListView currentListView = this.actionHandler.getToolView().getCurrentListView();
        if (currentListView instanceof ThumbnailView) {
            this.updateViewButton(thumbnailViewButtonIcon);
        } else if (currentListView instanceof ProductEntryList) {
            this.updateViewButton(listViewButtonIcon);
        } else if (currentListView instanceof ProductEntryTable) {
            this.updateViewButton(tableViewButtonIcon);
        }
    }

    private void updateViewButton(ImageIcon icon) {
        this.button.setIcon(icon);
        this.button.setRolloverIcon(icon);
    }
}

