/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.SnapFileChooser;

public class ExportListActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon exportListIcon = TangoIcons.actions_document_save_as((TangoIcons.Res)TangoIcons.Res.R22);
    private JButton button = null;
    private ProductLibraryActions actionHandler;
    private static final String lastExportDirPreferenceKey = "snap.productlibrary.last_export_dir";

    @Override
    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"exportListButton", (String)"Export list of selected products", (ImageIcon)exportListIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        }
        return this.button;
    }

    @Override
    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(selections.length > 0 && ProductLibraryActions.allProductsExist(selections));
    }

    @Override
    public void performAction(ProgressMonitor pm) {
        File[] fileList;
        File file = ExportListActionExt.getExportFile();
        if (file != null && (fileList = this.actionHandler.getSelectedFiles()).length != 0) {
            ExportListActionExt.exportFileList(file, fileList);
            ExportListActionExt.viewFile(file);
        }
    }

    private static File getExportFile() {
        File file;
        Preferences preferences = SnapApp.getDefault().getPreferences();
        File currentDir = new File(preferences.get(lastExportDirPreferenceKey, SystemUtils.getUserHomeDir().getPath()));
        SnapFileChooser fileChooser = new SnapFileChooser();
        fileChooser.setDialogTitle("Export list of products");
        fileChooser.setCurrentDirectory(currentDir);
        int result = fileChooser.showSaveDialog((Component)SnapApp.getDefault().getMainFrame());
        if (result == 0 && (file = fileChooser.getSelectedFile()) != null) {
            File parentFolder = file.getAbsoluteFile().getParentFile();
            if (parentFolder != null) {
                preferences.put(lastExportDirPreferenceKey, parentFolder.getPath());
            }
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportFileList(File file, File[] fileList) {
        try (PrintStream p = null;
             FileOutputStream out = new FileOutputStream(file.getAbsolutePath(), false);){
            p = new PrintStream(out);
            for (File f : fileList) {
                p.println(f.getAbsolutePath());
            }
        }
    }

    private static void viewFile(File file) {
        if (Desktop.isDesktopSupported() && file.exists()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (Exception e) {
                SnapApp.getDefault().handleError("Error opening file " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

