/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.extensions;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryToolView;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.UIUtils;

public class BatchActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon batchIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/batch24.png", ProductLibraryToolView.class);
    private JButton button = null;
    private ProductLibraryActions actionHandler;

    @Override
    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Override
    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"batchProcessButton", (String)"Batch", (ImageIcon)batchIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
            this.button.setToolTipText("Right click to select a graph");
            this.button.setComponentPopupMenu(this.createGraphPopup());
        }
        return this.button;
    }

    private JPopupMenu createGraphPopup() {
        Path graphPath = ResourceUtils.getGraphFolder((String)"");
        JPopupMenu popup = new JPopupMenu();
        if (Files.exists(graphPath, new LinkOption[0])) {
            this.createGraphMenu(popup, graphPath.toFile());
        }
        return popup;
    }

    private void createGraphMenu(JPopupMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (final File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BatchActionExt.this.button.isEnabled()) {
                        BatchActionExt.this.batchProcess(BatchActionExt.this.actionHandler.getToolView().getSelectedProductEntries(), file);
                    }
                }
            });
            menu.add(item);
        }
    }

    private void createGraphMenu(JMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (final File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (BatchActionExt.this.button.isEnabled()) {
                        BatchActionExt.this.batchProcess(BatchActionExt.this.actionHandler.getToolView().getSelectedProductEntries(), file);
                    }
                }
            });
            menu.add(item);
        }
    }

    @Override
    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(selections.length > 0 && ProductLibraryActions.allProductsExist(selections));
    }

    @Override
    public void performAction(ProgressMonitor pm) {
        this.batchProcess(this.actionHandler.getToolView().getSelectedProductEntries(), null);
    }

    private void batchProcess(ProductEntry[] productEntryList, File graphFile) {
        BatchGraphDialog batchDlg = new BatchGraphDialog(SnapApp.getDefault().getAppContext(), "Batch Processing", "batchProcessing", false);
        batchDlg.setInputFiles(productEntryList);
        if (graphFile != null) {
            batchDlg.LoadGraph(graphFile);
        }
        batchDlg.show();
    }
}

