/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider.DataProvider;

public class IDProvider
implements DataProvider {
    private final Comparator<ProductEntry> comparator = new IdComparator();
    private TableColumn column;

    @Override
    public Comparator<ProductEntry> getComparator() {
        return this.comparator;
    }

    @Override
    public void cleanUp(ProductEntry entry) {
    }

    @Override
    public TableColumn getTableColumn() {
        if (this.column == null) {
            this.column = new TableColumn();
            this.column.setHeaderValue("ID");
            this.column.setPreferredWidth(34);
            this.column.setResizable(false);
            this.column.setCellRenderer(new IDCellRenderer());
        }
        return this.column;
    }

    private static class IdComparator
    implements Comparator<ProductEntry> {
        private IdComparator() {
        }

        @Override
        public int compare(ProductEntry o1, ProductEntry o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getId() < o2.getId()) {
                return -1;
            }
            return 1;
        }
    }

    private static class IDCellRenderer
    extends DefaultTableCellRenderer {
        private IDCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ProductEntry entry = (ProductEntry)value;
            if (entry != null) {
                String text = String.valueOf(entry.getId());
                JLabel jlabel = (JLabel)super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
                jlabel.setFont(jlabel.getFont().deriveFont(1));
                if (entry.getFile() != null) {
                    jlabel.setToolTipText(entry.getFile().getAbsolutePath());
                }
                return jlabel;
            }
            return null;
        }
    }
}

