/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.rcp.SnapApp;

public class AOIManager {
    public static final String LAST_AOI_PATH = "snap.aoi.last_aoi_path";
    private static final String LAST_INPUT_PATH = "snap.aoi.last_input_path";
    private static final String LAST_OUTPUT_PATH = "snap.aoi.last_output_path";
    private static final String LAST_GRAPH_PATH = "snap.aoi.last_graph_path";
    private static final String AOI_FILE = "snap.aoi.AOIFile_";
    private static final String AOI_BATCH_TARGET = "snap.aoi.AOITarget_";
    private static final Preferences pref = SnapApp.getDefault().getPreferences();
    private final List<AOI> aoiList = new ArrayList<AOI>(5);

    public AOI[] getAOIList() {
        return this.aoiList.toArray(new AOI[this.aoiList.size()]);
    }

    public AOI createAOI(File aoiFile) {
        AOI aoi = new AOI(aoiFile);
        this.aoiList.add(aoi);
        return aoi;
    }

    public void removeAOI(AOI aoi) {
        this.aoiList.remove(aoi);
    }

    public File getNewAOIFile() {
        return new File(AOIManager.getAOIFolder(), "aoi_" + (this.aoiList.size() + 1));
    }

    public AOI getAOIAt(int index) {
        return this.aoiList.get(index);
    }

    public static File getAOIFolder() {
        File aoiFolder = new File(SystemUtils.getAuxDataPath().toFile(), File.separator + "aoi");
        if (!aoiFolder.exists()) {
            aoiFolder.mkdirs();
        }
        return aoiFolder;
    }

    static String getLastInputPath() {
        return pref.get(LAST_INPUT_PATH, "");
    }

    public static void setLastInputPath(String path) {
        pref.put(LAST_INPUT_PATH, path);
    }

    static String getLastOutputPath() {
        return pref.get(LAST_OUTPUT_PATH, "");
    }

    public static void setLastOutputPath(String path) {
        pref.put(LAST_OUTPUT_PATH, path);
    }

    public static void addBaseDir(File baseDir) {
        pref.put(AOI_FILE + baseDir.getAbsolutePath(), baseDir.getAbsolutePath());
    }

    public static void setBatchProcessResult(AOI aoi, File inputFile, File targetFile) {
        pref.put(AOI_BATCH_TARGET + inputFile.getAbsolutePath() + '_' + aoi.getProcessingGraph(), targetFile.getAbsolutePath());
    }

    public static boolean hasBeenBatchedProcessed(AOI aoi, File inputFile) {
        String targetFileStr = pref.get(AOI_BATCH_TARGET + inputFile.getAbsolutePath() + '_' + aoi.getProcessingGraph(), null);
        if (targetFileStr != null) {
            File targetFile = new File(targetFileStr);
            return targetFile.exists();
        }
        return false;
    }

    public static void removeBaseDir(File baseDir) {
        pref.remove(AOI_FILE + baseDir.getAbsolutePath());
    }

    public static File[] getBaseDirs() {
        ArrayList<File> dirList = new ArrayList<File>();
        try {
            for (String key : pref.keys()) {
                File file;
                String path;
                if (!key.startsWith(AOI_FILE) || (path = pref.get(key, null)) == null || !(file = new File(path)).exists()) continue;
                dirList.add(file);
            }
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("AOIConfig unable to reload base folders", (Throwable)e);
        }
        return dirList.toArray(new File[dirList.size()]);
    }
}

