/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOIManager;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;

public class DatabaseScannerListener
implements DBScanner.DBScannerListener {
    private final ProductDB db;
    private final AOI processingAOI;
    private final boolean autoApply;
    private final boolean closeOnDone;
    private final BatchGraphDialog.BatchProcessListener batchListener;
    private final AOIManager aoiManager;

    DatabaseScannerListener(ProductDB database, AOI aoi, boolean automaticallyApply, boolean closeOnDone, BatchGraphDialog.BatchProcessListener listener, AOIManager aoiManager) {
        this.db = database;
        this.processingAOI = aoi;
        this.autoApply = automaticallyApply;
        this.closeOnDone = closeOnDone;
        this.batchListener = listener;
        this.aoiManager = aoiManager;
    }

    @Override
    public void notifyMSG(DBScanner dbScanner, DBScanner.DBScannerListener.MSG msg) {
        if (msg == DBScanner.DBScannerListener.MSG.FOLDERS_SCANNED && this.processingAOI != null) {
            ProductEntry[] productEntryList = this.findInputProducts(this.db, this.processingAOI);
            if (productEntryList == null) {
                return;
            }
            if (productEntryList.length == 0) {
                if (!this.closeOnDone) {
                    Dialogs.showWarning((String)"No input products found matching the selected criteria\nor all products have already been processed");
                }
                this.batchListener.notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG.CLOSE, "");
                return;
            }
            HashMap<File, File[]> slaveFileMap = new HashMap<File, File[]>();
            if (this.processingAOI.getFindSlaves()) {
                ArrayList<ProductEntry> toProcessEntries = new ArrayList<ProductEntry>();
                for (ProductEntry entry : productEntryList) {
                    File[] slaveFiles = DatabaseScannerListener.findCCDPairs(this.db, entry, this.processingAOI);
                    if (slaveFiles == null || slaveFiles.length <= 0 || entry.getFile() == null) continue;
                    slaveFileMap.put(entry.getFile(), slaveFiles);
                    toProcessEntries.add(entry);
                }
                productEntryList = toProcessEntries.toArray(new ProductEntry[toProcessEntries.size()]);
            }
            if (productEntryList.length == 0) {
                if (!this.closeOnDone) {
                    Dialogs.showWarning((String)"No slave products founds");
                }
                this.batchListener.notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG.CLOSE, "");
                return;
            }
            this.batchProcess(productEntryList, slaveFileMap, new File(this.processingAOI.getOutputFolder()), new File(this.processingAOI.getProcessingGraph()));
        }
    }

    private void batchProcess(ProductEntry[] productEntryList, Map<File, File[]> slaveFileMap, File outputFolder, File graphFile) {
        BatchGraphDialog batchDlg = new BatchGraphDialog(SnapApp.getDefault().getAppContext(), "Batch Processing", "batchProcessing", this.closeOnDone);
        batchDlg.addListener(this.batchListener);
        batchDlg.setInputFiles(productEntryList);
        batchDlg.setTargetFolder(outputFolder);
        batchDlg.setSlaveFileMap(slaveFileMap);
        if (graphFile != null) {
            batchDlg.LoadGraph(graphFile);
        }
        batchDlg.show();
        if (this.autoApply) {
            batchDlg.onApply();
        }
    }

    private ProductEntry[] findInputProducts(ProductDB db, AOI aoi) {
        DBQuery dbQuery = new DBQuery();
        dbQuery.setBaseDir(new File(aoi.getInputFolder()));
        dbQuery.setSelectionRect(aoi.getPoints());
        try {
            ProductEntry[] queryResult = dbQuery.queryDatabase(db);
            ArrayList<ProductEntry> inputEntries = new ArrayList<ProductEntry>();
            for (ProductEntry entry : queryResult) {
                if (AOIManager.hasBeenBatchedProcessed(aoi, entry.getFile())) continue;
                inputEntries.add(entry);
            }
            return inputEntries.toArray(new ProductEntry[inputEntries.size()]);
        }
        catch (Throwable t) {
            Dialogs.showError((String)("Query database error:" + t.getMessage()));
            return null;
        }
    }

    private static File[] findCCDPairs(ProductDB db, ProductEntry master, AOI aoi) {
        DBQuery dbQuery = aoi.getSlaveDBQuery();
        if (dbQuery == null) {
            dbQuery = new DBQuery();
        }
        dbQuery.setExcludeDir(new File(aoi.getInputFolder()));
        dbQuery.setFreeQuery("PRODUCT <> '" + master.getName() + "'");
        dbQuery.setSelectionRect(master.getGeoBoundary());
        try {
            ProductEntry[] entries = dbQuery.queryDatabase(db);
            return ProductEntry.getFileList((ProductEntry[])DatabaseScannerListener.getClosestDatePairs(entries, master, aoi));
        }
        catch (Throwable t) {
            Dialogs.showError((String)("Query database error:" + t.getMessage()));
            return null;
        }
    }

    private static ProductEntry[] getClosestDatePairs(ProductEntry[] entries, ProductEntry master, AOI aoi) {
        double endTime;
        double masterTime;
        double cutoffTime = masterTime = master.getFirstLineTime().getMJD();
        DBQuery slaveQuery = aoi.getSlaveDBQuery();
        if (slaveQuery != null && slaveQuery.getEndDate() != null && (endTime = ProductData.UTC.create((Date)slaveQuery.getEndDate().getTime(), (long)0L).getMJD()) > masterTime) {
            cutoffTime = endTime;
        }
        ArrayList resultList = new ArrayList(aoi.getMaxSlaves());
        HashMap<Double, ProductEntry> timesMap = new HashMap<Double, ProductEntry>();
        ArrayList<Double> diffList = new ArrayList<Double>();
        for (ProductEntry entry : entries) {
            double entryTime = entry.getFirstLineTime().getMJD();
            if (!(entryTime < cutoffTime)) continue;
            double diff = Math.abs(masterTime - entryTime);
            timesMap.put(diff, entry);
            diffList.add(diff);
        }
        Collections.sort(diffList);
        for (Double diff : diffList) {
            resultList.add(timesMap.get(diff));
            if (resultList.size() < aoi.getMaxSlaves()) continue;
            break;
        }
        return resultList.toArray(new ProductEntry[resultList.size()]);
    }
}

