/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.AOIMonitoringToolView;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.DatabaseScannerListener;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOIManager;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.DirectoryWatch;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;
import org.esa.snap.productlibrary.rcp.toolviews.model.ProductLibraryConfig;
import org.esa.snap.rcp.SnapApp;

class AOIMonitor {
    private AOI[] aoiList = new AOI[0];
    private final ArrayList<AOI> aoiQueue = new ArrayList();
    private final DirectoryWatch dirWatch = new DirectoryWatch();
    private final AOIMonitoringToolView aoiMonitoringToolview;
    private static final int WATCH_RATE = 5000;
    private boolean isStarted = false;
    private AOI processingAOI = null;
    private final ProductLibraryConfig libConfig = new ProductLibraryConfig(SnapApp.getDefault().getPreferences());

    AOIMonitor(AOIMonitoringToolView toolview) {
        this.aoiMonitoringToolview = toolview;
        this.dirWatch.addListener(new DirWatchListener());
    }

    synchronized void start(AOI[] aoiList) {
        this.aoiList = aoiList;
        for (AOI aoi : aoiList) {
            this.dirWatch.add(new File(aoi.getInputFolder()));
        }
        this.dirWatch.start(5000L);
        this.isStarted = true;
    }

    synchronized void stop() {
        this.dirWatch.stop();
        this.dirWatch.removeAll();
        this.isStarted = false;
    }

    boolean isStarted() {
        return this.isStarted;
    }

    private void monitorAOI() {
        if (this.aoiQueue.isEmpty()) {
            return;
        }
        this.dirWatch.stop();
        this.processingAOI = this.aoiQueue.get(0);
        this.aoiQueue.remove(0);
        try {
            LabelBarProgressMonitor progMon = this.aoiMonitoringToolview.createNewProgressMonitor();
            this.libConfig.addBaseDir(new File(this.processingAOI.getInputFolder()));
            DBScanner.Options options = new DBScanner.Options(true, false, false);
            DBScanner scanner = new DBScanner(this.aoiMonitoringToolview.getProductDatabase(), new File(this.processingAOI.getInputFolder()), options, (ProgressMonitor)progMon);
            scanner.addListener(new DatabaseScannerListener(this.aoiMonitoringToolview.getProductDatabase(), this.processingAOI, true, true, new MonitorBatchProcessListener(), this.aoiMonitoringToolview.getAoiManager()));
            scanner.execute();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private class MonitorBatchProcessListener
    implements BatchGraphDialog.BatchProcessListener {
        private MonitorBatchProcessListener() {
        }

        public synchronized void notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG msg, File[] inputFileList, File[] outputFileList) {
            if (msg.equals((Object)BatchGraphDialog.BatchProcessListener.BatchMSG.DONE)) {
                if (AOIMonitor.this.processingAOI != null) {
                    for (int i = 0; i < outputFileList.length; ++i) {
                        AOIMonitor.this.aoiMonitoringToolview.getAoiManager();
                        AOIManager.setBatchProcessResult(AOIMonitor.this.processingAOI, inputFileList[i], outputFileList[i]);
                    }
                    AOIMonitor.this.processingAOI = null;
                }
                if (AOIMonitor.this.aoiQueue.isEmpty()) {
                    AOIMonitor.this.dirWatch.start(5000L);
                } else {
                    AOIMonitor.this.monitorAOI();
                }
            }
        }

        public synchronized void notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG msg, String text) {
            if (msg.equals((Object)BatchGraphDialog.BatchProcessListener.BatchMSG.CLOSE)) {
                if (AOIMonitor.this.aoiQueue.isEmpty()) {
                    AOIMonitor.this.dirWatch.start(5000L);
                } else {
                    AOIMonitor.this.monitorAOI();
                }
            }
        }
    }

    private class DirWatchListener
    implements DirectoryWatch.DirectoryWatchListener {
        private DirWatchListener() {
        }

        @Override
        public void filesAdded(File[] files) {
            for (File f : files) {
                String filePath = f.getParent();
                for (AOI aoi : AOIMonitor.this.aoiList) {
                    if (AOIMonitor.this.aoiQueue.contains(aoi) || !aoi.getInputFolder().equalsIgnoreCase(filePath)) continue;
                    AOIMonitor.this.aoiQueue.add(aoi);
                }
            }
            AOIMonitor.this.monitorAOI();
        }

        @Override
        public void filesRemoved(File[] files) {
        }
    }
}

