/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring;

import com.jidesoft.swing.FolderChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOIManager;
import org.esa.snap.productlibrary.rcp.toolviews.DatabasePane;
import org.esa.snap.productlibrary.rcp.toolviews.model.ProductLibraryConfig;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.FolderRepository;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.RepositoryInterface;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.ScihubRepository;
import org.esa.snap.productlibrary.rcp.toolviews.support.ComboCellRenderer;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;

public class AOIDialog
extends ModalDialog {
    private final JTextField nameField = new JTextField("");
    private final JTextField inputFolderField = new JTextField("");
    private final JButton inputFolderButton = new JButton("...");
    private final JTextField outputFolderField = new JTextField("");
    private final JButton outputFolderButton = new JButton("...");
    private final JTextField graphField = new JTextField("");
    private final JButton graphButton = new JButton("...");
    private final JCheckBox pairsCheckBox = new JCheckBox("Find CCD Slaves");
    private final JTextField maxSlavesField = new JTextField("1");
    private JComboBox<RepositoryInterface> repositoryListCombo;
    private DatabasePane dbPane;
    private WorldMapUI worldMapUI;
    private final AOI aoi;

    public AOIDialog(Window parent, AOI theAOI) throws Exception {
        super(parent, "Area of Interest", 33, null);
        this.aoi = theAOI;
        this.inputFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window;
                File folder;
                FolderChooser chooser = new FolderChooser();
                chooser.setDialogTitle("Input folder");
                if (AOIDialog.this.aoi.getInputFolder() != null && (folder = new File(AOIDialog.this.aoi.getInputFolder())).exists()) {
                    chooser.setSelectedFolder(folder);
                }
                if (chooser.showDialog((Component)(window = SwingUtilities.getWindowAncestor((JComponent)e.getSource())), "Select") == 0) {
                    File selectedFolder = chooser.getSelectedFolder();
                    AOIDialog.this.inputFolderField.setText(selectedFolder.getAbsolutePath());
                    AOIManager.setLastInputPath(selectedFolder.getAbsolutePath());
                }
            }
        });
        this.outputFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window;
                File folder;
                FolderChooser chooser = new FolderChooser();
                chooser.setDialogTitle("Output folder");
                if (AOIDialog.this.aoi.getOutputFolder() != null && (folder = new File(AOIDialog.this.aoi.getOutputFolder())).exists()) {
                    chooser.setSelectedFolder(folder);
                }
                if (chooser.showDialog((Component)(window = SwingUtilities.getWindowAncestor((JComponent)e.getSource())), "Select") == 0) {
                    File selectedFolder = chooser.getSelectedFolder();
                    AOIDialog.this.outputFolderField.setText(selectedFolder.getAbsolutePath());
                    AOIManager.setLastOutputPath(selectedFolder.getAbsolutePath());
                }
            }
        });
        this.graphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"AOI Processing Graph", (boolean)false, null, (String)"graphbuilder.last_graph_path");
                if (file != null) {
                    AOIDialog.this.graphField.setText(file.getAbsolutePath());
                }
            }
        });
        this.pairsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean findPairs = e.getStateChange() == 1;
                AOIDialog.this.dbPane.setVisible(findPairs);
                if (findPairs) {
                    // empty if block
                }
                AOIDialog.this.repositoryListCombo.setVisible(findPairs);
                AOIDialog.this.maxSlavesField.setEnabled(findPairs);
                AOIDialog.this.getJDialog().pack();
            }
        });
        this.initUI();
        this.populateRepositoryListCombo(new ProductLibraryConfig(SnapApp.getDefault().getPreferences()));
        this.populateFields();
    }

    private void initUI() throws Exception {
        JPanel contentPane = new JPanel(new BorderLayout(4, 4));
        JPanel northPane = GridBagUtils.createPanel();
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)northPane, (GridBagConstraints)gbc, (String)"Name:", (JComponent)this.nameField);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)northPane, (GridBagConstraints)gbc, (String)"Input Folder:", (JComponent)this.inputFolderField);
        this.inputFolderField.setColumns(50);
        gbc.gridx = 2;
        northPane.add((Component)this.inputFolderButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)northPane, (GridBagConstraints)gbc, (String)"Output Folder:", (JComponent)this.outputFolderField);
        gbc.gridx = 2;
        northPane.add((Component)this.outputFolderButton, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)northPane, (GridBagConstraints)gbc, (String)"Processing Graph:", (JComponent)this.graphField);
        gbc.gridx = 2;
        northPane.add((Component)this.graphButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        northPane.add((Component)this.pairsCheckBox, gbc);
        gbc.gridx = 1;
        JLabel maxSlavesLabel = new JLabel("Max Number of Slaves:");
        maxSlavesLabel.setHorizontalAlignment(4);
        northPane.add((Component)maxSlavesLabel, gbc);
        gbc.gridx = 2;
        northPane.add((Component)this.maxSlavesField, gbc);
        this.repositoryListCombo = new JComboBox();
        this.repositoryListCombo.setRenderer(new ComboCellRenderer());
        this.repositoryListCombo.setVisible(false);
        this.repositoryListCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    RepositoryInterface repo = (RepositoryInterface)AOIDialog.this.repositoryListCombo.getSelectedItem();
                    AOIDialog.this.dbPane.setRepository(repo);
                }
            }
        });
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        northPane.add(this.repositoryListCombo, gbc);
        contentPane.add((Component)northPane, "North");
        MyDatabaseQueryListener dbQueryListener = new MyDatabaseQueryListener();
        this.dbPane = new DatabasePane();
        this.dbPane.setDBQuery(this.aoi.getSlaveDBQuery());
        this.dbPane.addListener(dbQueryListener);
        this.dbPane.setVisible(false);
        contentPane.add((Component)this.dbPane, "West");
        this.worldMapUI = new WorldMapUI();
        this.worldMapUI.addListener((WorldMapUI.WorldMapUIListener)dbQueryListener);
        contentPane.add((Component)this.worldMapUI.getWorlMapPane(), "East");
        this.setContent(contentPane);
    }

    private void populateRepositoryListCombo(ProductLibraryConfig config) {
        File[] baseDirList;
        this.repositoryListCombo.insertItemAt(new FolderRepository("All_Folders", null), 0);
        this.repositoryListCombo.insertItemAt(new ScihubRepository(), 1);
        for (File f : baseDirList = config.getBaseDirs()) {
            this.repositoryListCombo.insertItemAt(new FolderRepository(f.getAbsolutePath(), f), this.repositoryListCombo.getItemCount());
        }
        if (baseDirList.length > 0) {
            this.repositoryListCombo.setSelectedIndex(0);
        }
    }

    private void populateFields() {
        this.nameField.setText(this.aoi.getName());
        this.inputFolderField.setText(this.aoi.getInputFolder());
        this.outputFolderField.setText(this.aoi.getOutputFolder());
        this.graphField.setText(this.aoi.getProcessingGraph());
        this.pairsCheckBox.setSelected(this.aoi.getFindSlaves());
        this.maxSlavesField.setEnabled(this.aoi.getFindSlaves());
        GeoPos[] aoiPoints = this.aoi.getPoints();
        if (aoiPoints.length > 2) {
            this.worldMapUI.setSelectionStart(aoiPoints[0].lat, aoiPoints[0].lon);
            this.worldMapUI.setSelectionEnd(aoiPoints[2].lat, aoiPoints[2].lon);
        }
    }

    public static boolean validateFolder(File file) {
        if (!file.exists() && !file.mkdirs()) {
            Dialogs.showError((String)("Unable to create folder\n" + file.getAbsolutePath()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onOK() {
        try {
            this.aoi.setName(this.nameField.getText());
            File inputFolder = new File(this.inputFolderField.getText());
            if (!AOIDialog.validateFolder(inputFolder)) {
                return;
            }
            this.aoi.setInputFolder(inputFolder.getAbsolutePath());
            File outputFolder = new File(this.outputFolderField.getText());
            if (!AOIDialog.validateFolder(outputFolder)) {
                return;
            }
            this.aoi.setOutputFolder(outputFolder.getAbsolutePath());
            File graph = new File(this.graphField.getText());
            if (!graph.exists()) {
                Dialogs.showError((String)("Please select a valid graph file\n" + graph.getAbsolutePath() + " does not exist"));
                return;
            }
            this.aoi.setProcessingGraph(graph.getAbsolutePath());
            this.aoi.setFindSlaves(this.pairsCheckBox.isSelected());
            this.aoi.setMaxSlaves(Integer.parseInt(this.maxSlavesField.getText()));
            this.aoi.setSlaveDBQuery(this.dbPane.getDBQuery());
            this.aoi.save();
        }
        catch (Throwable t) {
            Dialogs.showError((String)("Unable to save AOI: " + t.getMessage()));
        }
        finally {
            this.hide();
        }
    }

    private class MyDatabaseQueryListener
    implements DatabasePane.DatabaseQueryListener,
    WorldMapUI.WorldMapUIListener {
        private MyDatabaseQueryListener() {
        }

        @Override
        public void notifyNewEntryListAvailable() {
        }

        public void notifyNewMapSelectionAvailable() {
            AOIDialog.this.aoi.setPoints(AOIDialog.this.worldMapUI.getSelectionBox());
        }
    }
}

