/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.main;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.metadata.MetadataResourceEngine;
import com.bc.ceres.metadata.SimpleFileSystem;
import com.bc.ceres.resource.Resource;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.XppDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import org.apache.velocity.VelocityContext;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.common.ReadOp;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphProcessingObserver;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeContext;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.gpf.main.CommandLineArgs;
import org.esa.snap.core.gpf.main.CommandLineContext;
import org.esa.snap.core.gpf.main.CommandLineUsage;
import org.esa.snap.core.gpf.main.DefaultCommandLineContext;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

class CommandLineTool
implements GraphProcessingObserver {
    static final String TOOL_NAME = "gpt";
    static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.ENGLISH);
    static final String READ_OP_ID_PREFIX = "ReadOp@";
    public static final String WRITE_OP_ID_PREFIX = "WriteOp@";
    private final CommandLineContext commandLineContext;
    private final MetadataResourceEngine metadataResourceEngine;
    private CommandLineArgs commandLineArgs;

    CommandLineTool() {
        this(new DefaultCommandLineContext());
    }

    CommandLineTool(CommandLineContext commandLineContext) {
        this.commandLineContext = commandLineContext;
        this.metadataResourceEngine = new MetadataResourceEngine((SimpleFileSystem)commandLineContext);
    }

    void run(String ... args) throws Exception {
        boolean stackTraceDumpEnabled = CommandLineArgs.isStackTraceDumpEnabled(args);
        try {
            this.commandLineArgs = CommandLineArgs.parseArgs(args);
            if (this.commandLineArgs.isHelpRequested()) {
                this.printHelp();
                return;
            }
            if (this.commandLineArgs.isDiagnosticRequested()) {
                this.printDiagnostics();
                return;
            }
            this.run();
        }
        catch (Error | RuntimeException e) {
            e.printStackTrace(System.err);
            throw e;
        }
        catch (Exception e) {
            if (stackTraceDumpEnabled) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
    }

    private void printHelp() {
        if (this.commandLineArgs.getOperatorName() != null) {
            this.commandLineContext.print(CommandLineUsage.getUsageTextForOperator(this.commandLineArgs.getOperatorName()));
        } else if (this.commandLineArgs.getGraphFilePath() != null) {
            this.commandLineContext.print(CommandLineUsage.getUsageTextForGraph(this.commandLineArgs.getGraphFilePath(), this.commandLineContext));
        } else {
            this.commandLineContext.print(CommandLineUsage.getUsageText());
        }
    }

    private void printDiagnostics() {
        this.initializeSystemProperties();
        this.initializeJAI();
        Runtime runtime = Runtime.getRuntime();
        this.commandLineContext.print("SNAP Release version " + SystemUtils.getReleaseVersion() + '\n');
        this.commandLineContext.print("SNAP home: " + System.getProperty("snap.home") + '\n');
        this.commandLineContext.print("SNAP debug: " + System.getProperty("snap.debug") + '\n');
        this.commandLineContext.print("SNAP log level: " + System.getProperty("snap.log.level") + '\n');
        this.commandLineContext.print("Java home: " + System.getProperty("java.home") + '\n');
        this.commandLineContext.print("Java version: " + System.getProperty("java.version") + '\n');
        this.commandLineContext.print("Processors: " + runtime.availableProcessors() + '\n');
        this.commandLineContext.print("Max memory: " + CommandLineTool.fromBytes(runtime.maxMemory()) + '\n');
        this.commandLineContext.print("Cache size: " + CommandLineTool.fromBytes(JAI.getDefaultInstance().getTileCache().getMemoryCapacity()) + '\n');
        this.commandLineContext.print("Tile parallelism: " + JAI.getDefaultInstance().getTileScheduler().getParallelism() + '\n');
        this.commandLineContext.print("Tile size: " + (int)JAI.getDefaultTileSize().getWidth() + " x " + (int)JAI.getDefaultTileSize().getHeight() + " pixels" + '\n');
        this.commandLineContext.print("\nTo configure your gpt memory usage:\n");
        this.commandLineContext.print("Edit snap/bin/gpt.vmoptions\n");
        this.commandLineContext.print("\nTo configure your gpt cache size and parallelism:\n");
        this.commandLineContext.print("Edit .snap/etc/snap.properties or gpt -c ${cachesize-in-GB}G -q ${parallelism} \n");
    }

    static String fromBytes(long bytes) {
        if (bytes > 0x40000000L) {
            return String.format("%.1f GB", (double)bytes / 1.073741824E9);
        }
        if (bytes > 0x100000L) {
            return String.format("%.1f MB", (double)bytes / 1048576.0);
        }
        if (bytes > 1024L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%d B", bytes);
    }

    private void run() throws Exception {
        this.initializeSystemProperties();
        this.initializeJAI();
        this.initVelocityContext();
        this.readMetadata();
        this.runGraphOrOperator();
        this.runVelocityTemplates();
    }

    private void initializeSystemProperties() {
        Map<String, String> systemPropertiesMap = this.commandLineArgs.getSystemPropertiesMap();
        for (Map.Entry<String, String> properties : systemPropertiesMap.entrySet()) {
            System.setProperty(properties.getKey(), properties.getValue());
        }
    }

    private void initializeJAI() {
        long tileCacheCapacity = this.commandLineArgs.getTileCacheCapacity();
        int tileSchedulerParallelism = this.commandLineArgs.getTileSchedulerParallelism();
        if (tileCacheCapacity > 0L) {
            JAI.enableDefaultTileCache();
            JAI.getDefaultInstance().getTileCache().setMemoryCapacity(tileCacheCapacity);
        } else {
            JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0L);
            JAI.disableDefaultTileCache();
        }
        if (tileSchedulerParallelism > 0) {
            JAI.getDefaultInstance().getTileScheduler().setParallelism(tileSchedulerParallelism);
        }
        long tileCacheSize = JAI.getDefaultInstance().getTileCache().getMemoryCapacity() / 0x100000L;
        this.commandLineContext.getLogger().fine(MessageFormat.format("JAI tile cache size is {0} MB", tileCacheSize));
        int schedulerParallelism = JAI.getDefaultInstance().getTileScheduler().getParallelism();
        this.commandLineContext.getLogger().fine(MessageFormat.format("JAI tile scheduler parallelism is {0}", schedulerParallelism));
    }

    private void initVelocityContext() throws Exception {
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("system", (Object)System.getProperties());
        velocityContext.put("softwareName", (Object)"SNAP gpt");
        String versionKey = String.format("%s.version", SystemUtils.getApplicationContextId());
        velocityContext.put("softwareVersion", (Object)System.getProperty(versionKey, ""));
        velocityContext.put("commandLineArgs", (Object)this.commandLineArgs);
        File targetFile = new File(this.commandLineArgs.getTargetFilePath());
        File parentFile = targetFile.getParentFile();
        velocityContext.put("targetFile", (Object)targetFile);
        velocityContext.put("targetDir", (Object)(parentFile != null ? parentFile : new File(".")));
        velocityContext.put("targetBaseName", (Object)FileUtils.getFilenameWithoutExtension((File)targetFile));
        velocityContext.put("targetName", (Object)targetFile.getName());
        velocityContext.put("targetFormat", (Object)this.commandLineArgs.getTargetFormatName());
    }

    private void readMetadata() throws Exception {
        if (this.commandLineArgs.getMetadataFilePath() != null) {
            this.readMetadata(this.commandLineArgs.getMetadataFilePath(), true);
        } else {
            this.readMetadata("metadata.properties", false);
        }
        this.readSourceMetadataFiles();
    }

    private void readMetadata(String path, boolean fail) throws Exception {
        block3: {
            try {
                this.metadataResourceEngine.readResource("metadata", path);
            }
            catch (Exception e) {
                if (fail) {
                    throw e;
                }
                String message = String.format("Failed to read metadata file '%s': %s", path, e.getMessage());
                if (!this.commandLineContext.fileExists(path)) break block3;
                this.logSevereProblem(message, e);
            }
        }
    }

    void readSourceMetadataFiles() {
        SortedMap<String, String> sourceFilePathMap = this.commandLineArgs.getSourceFilePathMap();
        for (String sourceId : sourceFilePathMap.keySet()) {
            String sourcePath = (String)sourceFilePathMap.get(sourceId);
            try {
                this.metadataResourceEngine.readRelatedResource(sourceId, sourcePath);
            }
            catch (Exception e) {
                String msgPattern = "Failed to load metadata file associated with '%s = %s': %s";
                this.logSevereProblem(String.format(msgPattern, sourceId, sourcePath, e.getMessage()), e);
            }
        }
    }

    private void runGraphOrOperator() throws Exception {
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("processingStartTime", (Object)DATETIME_FORMAT.format(new Date()));
        if (this.commandLineArgs.getOperatorName() != null) {
            this.runOperator();
        } else if (this.commandLineArgs.getGraphFilePath() != null) {
            this.runGraph();
        }
        velocityContext.put("processingStopTime", (Object)DATETIME_FORMAT.format(new Date()));
    }

    private void runOperator() throws Exception {
        Map<String, String> parameterMap = this.getRawParameterMap();
        String operatorName = this.commandLineArgs.getOperatorName();
        Map<String, Product> sourceProducts = this.getSourceProductMap();
        Map<String, Object> parameters = this.convertParameterMap(operatorName, parameterMap, sourceProducts);
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi operatorSpi = operatorSpiRegistry.getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new OperatorException(String.format("Unknown operator name '%s'.", operatorName));
        }
        Operator operator = operatorSpi.createOperator(parameters, sourceProducts);
        Product targetProduct = operator.getTargetProduct();
        OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
        if (operatorDescriptor.isAutoWriteDisabled()) {
            OperatorExecutor executor = OperatorExecutor.create(operator);
            executor.execute(ProgressMonitor.NULL);
        } else {
            String filePath = this.commandLineArgs.getTargetFilePath();
            String formatName = this.commandLineArgs.getTargetFormatName();
            this.writeProduct(targetProduct, filePath, formatName, this.commandLineArgs.isClearCacheAfterRowWrite());
        }
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("operator", (Object)operator);
        velocityContext.put("operatorSpi", (Object)operatorSpi);
        velocityContext.put("operatorMetadata", (Object)operatorDescriptor.getOperatorClass().getAnnotation(OperatorMetadata.class));
        velocityContext.put("operatorDescriptor", (Object)operatorDescriptor);
        velocityContext.put("operatorName", (Object)operatorName);
        velocityContext.put("parameters", parameters);
        velocityContext.put("sourceProduct", (Object)sourceProducts.get("sourceProduct"));
        velocityContext.put("sourceProducts", sourceProducts);
        velocityContext.put("targetProduct", (Object)targetProduct);
        velocityContext.put("targetProducts", (Object)new Product[]{targetProduct});
    }

    private void runGraph() throws Exception {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        Map<String, String> templateVariables = this.getRawParameterMap();
        Map<String, String> sourceNodeIdMap = this.getSourceNodeIdMap();
        templateVariables.putAll(sourceNodeIdMap);
        Graph graph = this.readGraph(this.commandLineArgs.getGraphFilePath(), templateVariables);
        Node lastNode = graph.getNode(graph.getNodeCount() - 1);
        SortedMap<String, String> sourceFilePathsMap = this.commandLineArgs.getSourceFilePathMap();
        String readOperatorAlias = OperatorSpi.getOperatorAlias(ReadOp.class);
        for (Map.Entry<String, String> entry : sourceFilePathsMap.entrySet()) {
            String sourceId = entry.getKey();
            String sourceFilePath = entry.getValue();
            String sourceNodeId = sourceNodeIdMap.get(sourceId);
            if (graph.getNode(sourceNodeId) != null) continue;
            DefaultDomElement configuration = new DefaultDomElement("parameters");
            configuration.createChild("file").setValue(sourceFilePath);
            Node sourceNode = new Node(sourceNodeId, readOperatorAlias);
            sourceNode.setConfiguration((DomElement)configuration);
            graph.addNode(sourceNode);
        }
        String operatorName = lastNode.getOperatorName();
        OperatorSpi operatorSpi = operatorSpiRegistry.getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new GraphException(String.format("Unknown operator name '%s'.", operatorName));
        }
        OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
        if (!operatorDescriptor.isAutoWriteDisabled()) {
            String writeOperatorAlias = OperatorSpi.getOperatorAlias(WriteOp.class);
            DefaultDomElement configuration = new DefaultDomElement("parameters");
            configuration.createChild("file").setValue(this.commandLineArgs.getTargetFilePath());
            configuration.createChild("formatName").setValue(this.commandLineArgs.getTargetFormatName());
            configuration.createChild("clearCacheAfterRowWrite").setValue(Boolean.toString(this.commandLineArgs.isClearCacheAfterRowWrite()));
            Node targetNode = new Node(WRITE_OP_ID_PREFIX + lastNode.getId(), writeOperatorAlias);
            targetNode.addSource(new NodeSource("source", lastNode.getId()));
            targetNode.setConfiguration((DomElement)configuration);
            graph.addNode(targetNode);
        }
        this.executeGraph(graph);
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        File graphFile = new File(this.commandLineArgs.getGraphFilePath());
        velocityContext.put("graph", (Object)graph);
        this.metadataResourceEngine.readResource("graphXml", graphFile.getPath());
    }

    private Map<String, Object> convertParameterMap(String operatorName, Map<String, String> parameterMap, Map<String, Product> sourceProductMap) throws ValidationException {
        Resource parametersResource;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PropertyContainer container = ParameterDescriptorFactory.createMapBackedOperatorPropertyContainer(operatorName, parameters, sourceProductMap);
        container.setDefaultValues();
        Object parametersObject = this.metadataResourceEngine.getVelocityContext().get("parameterFile");
        if (parametersObject instanceof Resource && (parametersResource = (Resource)parametersObject).isXml()) {
            OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
            OperatorSpi operatorSpi = operatorSpiRegistry.getOperatorSpi(operatorName);
            Class<? extends Operator> operatorClass = operatorSpi.getOperatorDescriptor().getOperatorClass();
            DefaultDomConverter domConverter = new DefaultDomConverter(operatorClass, (PropertyDescriptorFactory)new ParameterDescriptorFactory());
            DomElement parametersElement = CommandLineTool.createDomElement(parametersResource.getContent());
            try {
                domConverter.convertDomToValue(parametersElement, (Object)container);
            }
            catch (ConversionException e) {
                String msgPattern = "Operator '%s': cannot convert XML parameters for reason: %s";
                throw new RuntimeException(String.format(msgPattern, operatorName, e.getMessage()), e);
            }
        }
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String paramName = entry.getKey();
            String paramValue = entry.getValue();
            Property property = container.getProperty(paramName);
            if (property != null) {
                property.setValueFromText(paramValue);
                continue;
            }
            throw new RuntimeException(String.format("Operator '%s': unknown parameter '%s'", operatorName, paramName));
        }
        return parameters;
    }

    private static DomElement createDomElement(String xml) {
        XppDomWriter domWriter = new XppDomWriter();
        new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(xml), (XmlPullParser)new MXParser()), (HierarchicalStreamWriter)domWriter);
        XppDom xppDom = domWriter.getConfiguration();
        return new XppDomElement(xppDom);
    }

    private Map<String, Product> getSourceProductMap() throws IOException {
        TreeMap<File, Product> fileToProductMap = new TreeMap<File, Product>();
        TreeMap<String, Product> productMap = new TreeMap<String, Product>();
        SortedMap<String, String> sourceFilePathsMap = this.commandLineArgs.getSourceFilePathMap();
        for (Map.Entry<String, String> entry : sourceFilePathsMap.entrySet()) {
            String sourceId = entry.getKey();
            String sourceFilePath = entry.getValue();
            Product product = this.addProduct(sourceFilePath, fileToProductMap);
            productMap.put(sourceId, product);
        }
        return productMap;
    }

    private Product addProduct(String sourceFilepath, Map<File, Product> fileToProductMap) throws IOException {
        File sourceFile = new File(sourceFilepath).getCanonicalFile();
        Product product = fileToProductMap.get(sourceFile);
        if (product == null) {
            String s = sourceFile.getPath();
            product = this.readProduct(s);
            if (product == null) {
                throw new IOException("No appropriate product reader found for " + sourceFile);
            }
            fileToProductMap.put(sourceFile, product);
        }
        return product;
    }

    private Map<String, String> getRawParameterMap() throws Exception {
        Map<String, String> parameterMap;
        String parameterFilePath = this.commandLineArgs.getParameterFilePath();
        if (parameterFilePath != null) {
            VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
            velocityContext.put("parameters", this.commandLineArgs.getParameterMap());
            Resource parameterFile = this.metadataResourceEngine.readResource("parameterFile", parameterFilePath);
            SortedMap configFileMap = parameterFile.getMap();
            if (!parameterFile.isXml()) {
                configFileMap.putAll(this.commandLineArgs.getParameterMap());
            }
            parameterMap = configFileMap;
        } else {
            parameterMap = new HashMap<String, String>();
        }
        parameterMap.putAll(this.commandLineArgs.getParameterMap());
        this.metadataResourceEngine.getVelocityContext().put("parameters", parameterMap);
        return parameterMap;
    }

    private Map<String, String> getSourceNodeIdMap() throws IOException {
        TreeMap<File, String> fileToNodeIdMap = new TreeMap<File, String>();
        TreeMap<String, String> nodeIdMap = new TreeMap<String, String>();
        SortedMap<String, String> sourceFilePathsMap = this.commandLineArgs.getSourceFilePathMap();
        for (Map.Entry<String, String> entry : sourceFilePathsMap.entrySet()) {
            String sourceId = entry.getKey();
            String sourceFilePath = entry.getValue();
            String nodeId = this.addNodeId(sourceId, sourceFilePath, fileToNodeIdMap);
            nodeIdMap.put(sourceId, nodeId);
        }
        return nodeIdMap;
    }

    private String addNodeId(String sourceId, String sourceFilePath, Map<File, String> fileToNodeId) throws IOException {
        File sourceFile = new File(sourceFilePath).getCanonicalFile();
        return fileToNodeId.computeIfAbsent(sourceFile, k -> READ_OP_ID_PREFIX + sourceId);
    }

    Product readProduct(String filePath) throws IOException {
        return this.commandLineContext.readProduct(filePath);
    }

    void writeProduct(Product targetProduct, String filePath, String formatName, boolean clearCacheAfterRowWrite) throws IOException {
        this.commandLineContext.writeProduct(targetProduct, filePath, formatName, clearCacheAfterRowWrite);
    }

    Graph readGraph(String filePath, Map<String, String> templateVariables) throws IOException, GraphException {
        return this.commandLineContext.readGraph(filePath, templateVariables);
    }

    void executeGraph(Graph graph) throws GraphException {
        this.commandLineContext.executeGraph(graph, this);
    }

    private void runVelocityTemplates() {
        boolean velocityDirPathGiven;
        File velocityDir;
        String velocityDirPath = this.commandLineArgs.getVelocityTemplateDirPath();
        if (velocityDirPath != null) {
            velocityDir = new File(velocityDirPath);
            velocityDirPathGiven = true;
        } else {
            velocityDir = new File(".");
            velocityDirPathGiven = false;
        }
        String[] templateNames = velocityDir.list((dir, name) -> name.toLowerCase().endsWith(".vm"));
        Logger logger = this.commandLineContext.getLogger();
        if (templateNames == null) {
            if (velocityDirPathGiven) {
                String msgPattern = "Velocity template directory '%s' does not exist or inaccessible";
                logger.severe(String.format(msgPattern, velocityDir));
            }
            return;
        }
        if (templateNames.length == 0) {
            if (velocityDirPathGiven) {
                String msgPattern = "Velocity template directory '%s' does not contain any templates (*.vm)";
                logger.warning(String.format(msgPattern, velocityDir));
            }
            return;
        }
        if (!this.commandLineContext.isFile(this.commandLineArgs.getTargetFilePath())) {
            if (velocityDirPathGiven) {
                String msgPattern = "Target file '%s' does not exist, but is required to process velocity templates";
                logger.warning(String.format(msgPattern, this.commandLineArgs.getTargetFilePath()));
            }
            return;
        }
        for (String templateName : templateNames) {
            String msgPattern;
            try {
                String templatePath = velocityDir + "/" + templateName;
                msgPattern = "Processing metadata template " + templatePath;
                logger.info(String.format(msgPattern, this.commandLineArgs.getTargetFilePath()));
                this.metadataResourceEngine.writeRelatedResource(templatePath, this.commandLineArgs.getTargetFilePath());
            }
            catch (IOException e) {
                msgPattern = "Can't write related resource using template file '%s': %s";
                this.logSevereProblem(String.format(msgPattern, templateName, e.getMessage()), e);
            }
        }
    }

    private void logSevereProblem(String message, Exception e) {
        if (this.commandLineArgs.isStackTraceDump()) {
            this.commandLineContext.getLogger().log(Level.SEVERE, message, e);
        } else {
            this.commandLineContext.getLogger().severe(message);
        }
    }

    @Override
    public void graphProcessingStarted(GraphContext graphContext) {
    }

    @Override
    public void graphProcessingStopped(GraphContext graphContext) {
        VelocityContext velocityContext = this.metadataResourceEngine.getVelocityContext();
        velocityContext.put("graph", (Object)graphContext.getGraph());
        Product[] outputProducts = graphContext.getOutputProducts();
        if (outputProducts.length >= 1) {
            velocityContext.put("targetProduct", (Object)outputProducts[0]);
        }
        velocityContext.put("targetProducts", (Object)outputProducts);
        Product sourceProduct = null;
        Operator currentOperator = null;
        HashMap<String, Product> sourceProducts = new HashMap<String, Product>();
        for (Node node : graphContext.getGraph().getNodes()) {
            NodeContext nodeContext = graphContext.getNodeContext(node);
            currentOperator = nodeContext.getOperator();
            if (!(currentOperator instanceof ReadOp)) continue;
            Product product = currentOperator.getTargetProduct();
            if (sourceProduct == null) {
                sourceProduct = product;
            }
            if (!node.getId().startsWith(READ_OP_ID_PREFIX)) continue;
            String sourceId = node.getId().substring(READ_OP_ID_PREFIX.length());
            sourceProducts.put(sourceId, product);
        }
        if (currentOperator != null) {
            currentOperator.stopTileComputationObservation();
        }
        velocityContext.put("sourceProduct", sourceProduct);
        velocityContext.put("sourceProducts", sourceProducts);
    }

    @Override
    public void tileProcessingStarted(GraphContext graphContext, Rectangle tileRectangle) {
    }

    @Override
    public void tileProcessingStopped(GraphContext graphContext, Rectangle tileRectangle) {
    }
}

