/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.SourcelessOpImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.core.gpf.internal.TileImpl;
import org.esa.snap.core.image.ImageManager;

public class OperatorImage
extends SourcelessOpImage {
    private final OperatorContext operatorContext;
    private Band targetBand;

    public OperatorImage(Band targetBand, OperatorContext operatorContext) {
        this(targetBand, operatorContext, ImageManager.createSingleBandedImageLayout((RasterDataNode)targetBand));
    }

    private OperatorImage(Band targetBand, OperatorContext operatorContext, ImageLayout imageLayout) {
        super(imageLayout, (Map)operatorContext.getRenderingHints(), imageLayout.getSampleModel(null), imageLayout.getMinX(null), imageLayout.getMinY(null), imageLayout.getWidth(null), imageLayout.getHeight(null));
        this.targetBand = targetBand;
        this.operatorContext = operatorContext;
        OperatorContext.setTileCache((OpImage)this);
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public Band getTargetBand() {
        return this.targetBand;
    }

    protected void computeRect(PlanarImage[] ignored, WritableRaster tile, Rectangle destRect) {
        this.operatorContext.executeOperator(ProgressMonitor.NULL);
        long startNanos = System.nanoTime();
        Tile targetTile = this.operatorContext.isComputingImageOf(this.getTargetBand()) ? OperatorImage.createTargetTile(this.getTargetBand(), tile, destRect) : (this.requiresAllBands() ? this.operatorContext.getSourceTile((RasterDataNode)this.getTargetBand(), destRect) : null);
        this.operatorContext.startWatch();
        if (targetTile != null && this.operatorContext.getOperator().canComputeTile()) {
            this.operatorContext.getOperator().computeTile(this.getTargetBand(), targetTile, ProgressMonitor.NULL);
        }
        this.operatorContext.stopWatch();
        this.operatorContext.fireTileComputed(this, destRect, startNanos);
    }

    protected boolean requiresAllBands() {
        return this.operatorContext.requiresAllBands();
    }

    public synchronized void dispose() {
        this.targetBand = null;
        super.dispose();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("[");
        OperatorDescriptor operatorDescriptor = this.operatorContext.getOperatorSpi().getOperatorDescriptor();
        sb.append(operatorDescriptor.getAlias());
        sb.append(",");
        if (this.targetBand != null) {
            sb.append(this.targetBand.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    protected static TileImpl createTargetTile(Band band, WritableRaster targetTileRaster, Rectangle targetRectangle) {
        return new TileImpl((RasterDataNode)band, targetTileRaster, targetRectangle, true);
    }
}

