/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.python.gpf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.DefaultOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.util.ServiceFinder;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.python.PyBridge;
import org.esa.snap.python.gpf.PyOperator;

public class PyOperatorSpi
extends OperatorSpi {
    public PyOperatorSpi() {
        super(PyOperator.class);
    }

    public PyOperatorSpi(OperatorDescriptor operatorDescriptor) {
        super(operatorDescriptor);
    }

    private static void registerPythonOp(Path moduleRoot, String pythonClassName) {
        int lastDotPos = pythonClassName.lastIndexOf(46);
        String modulePath = "";
        String className = "";
        if (lastDotPos > 0 && !PyOperatorSpi.registerModule(moduleRoot, modulePath = pythonClassName.substring(0, lastDotPos), className = pythonClassName.substring(lastDotPos + 1))) {
            SystemUtils.LOG.warning(String.format("Python module not installed: invalid entry in %s: %s", moduleRoot, pythonClassName));
        }
        if (modulePath.isEmpty() || className.isEmpty()) {
            SystemUtils.LOG.warning(String.format("Invalid Python module entry in %s: %s", moduleRoot, pythonClassName));
        }
    }

    private static boolean registerModule(Path pythonModuleRoot, final String pythonModuleName, final String pythonClassName) {
        String pythonModuleRelPath = pythonModuleName.replace('.', '/');
        Path pythonModuleFile = pythonModuleRoot.resolve(pythonModuleRelPath + ".py");
        if (!Files.exists(pythonModuleFile, new LinkOption[0])) {
            SystemUtils.LOG.severe(String.format("Missing Python module '%s'", pythonModuleFile.toUri()));
            return false;
        }
        Path pythonInfoXmlFile = pythonModuleRoot.resolve(pythonModuleRelPath + "-info.xml");
        if (!Files.exists(pythonInfoXmlFile, new LinkOption[0])) {
            SystemUtils.LOG.warning(String.format("Missing operator metadata file '%s'. Using defaults.", pythonInfoXmlFile.toUri()));
        }
        DefaultOperatorDescriptor operatorDescriptor = PyOperatorSpi.createOperatorDescriptor(pythonInfoXmlFile, pythonModuleName);
        final File pythonModuleRootFile = FileUtils.toFile((Path)pythonModuleRoot);
        PyOperatorSpi operatorSpi = new PyOperatorSpi((OperatorDescriptor)operatorDescriptor){

            public Operator createOperator() throws OperatorException {
                PyOperator pyOperator = (PyOperator)super.createOperator();
                pyOperator.setParameterDefaultValues();
                pyOperator.setPythonModulePath(pythonModuleRootFile.getPath());
                pyOperator.setPythonModuleName(pythonModuleName);
                pyOperator.setPythonClassName(pythonClassName);
                return pyOperator;
            }
        };
        String operatorName = operatorDescriptor.getAlias() != null ? operatorDescriptor.getAlias() : operatorDescriptor.getName();
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(operatorName, (OperatorSpi)operatorSpi);
        SystemUtils.LOG.info(String.format("Python operator '%s' registered (Python module: '%s', class: '%s', root: '%s')", operatorName, pythonModuleName, pythonClassName, pythonModuleRootFile));
        return true;
    }

    private static DefaultOperatorDescriptor createOperatorDescriptor(Path pythonInfoXmlFile, String pythonModuleName) {
        DefaultOperatorDescriptor operatorDescriptor;
        if (Files.exists(pythonInfoXmlFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(pythonInfoXmlFile);){
                operatorDescriptor = DefaultOperatorDescriptor.fromXml((Reader)reader, (String)pythonInfoXmlFile.toUri().toString(), (ClassLoader)PyOperatorSpi.class.getClassLoader());
            }
            catch (IOException e) {
                SystemUtils.LOG.severe(String.format("Failed to read from '%s'", pythonInfoXmlFile));
                operatorDescriptor = null;
            }
        } else {
            operatorDescriptor = new DefaultOperatorDescriptor(pythonModuleName, PyOperator.class);
        }
        return operatorDescriptor;
    }

    static {
        ServiceFinder serviceFinder = new ServiceFinder(PyOperatorSpi.class);
        if (Files.isDirectory(PyBridge.PYTHON_CONFIG_DIR, new LinkOption[0])) {
            serviceFinder.addSearchPath(PyBridge.PYTHON_CONFIG_DIR);
        }
        serviceFinder.addSearchPathsFromPreferences("snap.pythonExtraPaths");
        serviceFinder.setUseClassPath(true);
        for (ServiceFinder.Module module : serviceFinder.findServices()) {
            for (String pythonClassName : module.getServiceNames()) {
                PyOperatorSpi.registerPythonOp(module.getPath(), pythonClassName);
            }
        }
    }
}

