/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.python;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.TreeCopier;
import org.esa.snap.runtime.Config;
import org.jpy.PyLib;

public class PyBridge {
    public static final String PYTHON_EXECUTABLE_PROPERTY = "snap.pythonExecutable";
    public static final String PYTHON_MODULE_DIR_PROPERTY = "snap.pythonModuleDir";
    public static final String FORCE_PYTHON_CONFIG_PROPERTY = "snap.forcePythonConfig";
    public static final String PYTHON_EXTRA_PATHS_PROPERTY = "snap.pythonExtraPaths";
    public static final Path PYTHON_CONFIG_DIR;
    private static final String SNAP_PYTHON_DIRNAME = "snap-python";
    private static final String JPY_DEBUG_PROPERTY = "jpy.debug";
    private static final String JPY_CONFIG_PROPERTY = "jpy.config";
    private static final String SNAPPY_NAME = "snappy";
    private static final String SNAPPY_PROPERTIES_NAME = "snappy.properties";
    private static final String SNAPPYUTIL_PY_FILENAME = "snappyutil.py";
    private static final String SNAPPYUTIL_LOG_FILENAME = "snappyutil.log";
    private static final String JPY_JAVA_API_CONFIG_FILENAME = "jpyconfig.properties";
    private static final Path MODULE_CODE_BASE_PATH;
    private static boolean established;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void establish() throws IOException {
        if (established) {
            return;
        }
        Path snappyPath = PyBridge.installPythonModule(null, null, null);
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            if (!established) {
                PyBridge.startPython(snappyPath.getParent());
                established = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized Path installPythonModule(Path pythonExecutable, Path snappyParentDir, Boolean forcePythonConfig) throws IOException {
        PyBridge.loadPythonConfig();
        if (pythonExecutable == null) {
            pythonExecutable = PyBridge.getPythonExecutable();
        }
        if (snappyParentDir == null) {
            snappyParentDir = PyBridge.getSnappyParentDir();
        }
        if (forcePythonConfig == null) {
            forcePythonConfig = PyBridge.isForceGeneratingNewPythonConfig();
        }
        Path snappyPath = snappyParentDir.resolve(SNAPPY_NAME);
        if (forcePythonConfig.booleanValue() || !Files.isDirectory(snappyPath, new LinkOption[0])) {
            PyBridge.unpackPythonModuleDir(snappyPath);
            PyBridge.storePythonConfig(pythonExecutable, snappyParentDir);
        }
        Path jpyConfigFile = snappyPath.resolve(JPY_JAVA_API_CONFIG_FILENAME);
        if (forcePythonConfig.booleanValue() || !Files.exists(jpyConfigFile, new LinkOption[0])) {
            PyBridge.configureJpy(pythonExecutable, snappyPath);
        }
        if (!Files.exists(jpyConfigFile, new LinkOption[0])) {
            throw new IOException(String.format("SNAP-Python configuration incomplete.\nMissing file '%s'.\nPlease check the log file '%s'.", jpyConfigFile, snappyPath.resolve(SNAPPYUTIL_LOG_FILENAME)));
        }
        System.setProperty(JPY_CONFIG_PROPERTY, jpyConfigFile.toString());
        if (Debug.isEnabled() && System.getProperty(JPY_DEBUG_PROPERTY) == null) {
            System.setProperty(JPY_DEBUG_PROPERTY, "true");
        }
        return snappyPath;
    }

    public static void extendSysPath(String path) {
        if (path != null) {
            String code = String.format("import sys;\np = '%s';\nif not p in sys.path: sys.path.append(p)", path.replace("\\", "\\\\"));
            PyLib.execScript(code);
        }
    }

    private static void configureJpy(Path pythonExecutable, Path snappyDir) throws IOException {
        String osArch;
        String javaHome;
        String defaultJvmHeapSpace;
        SystemUtils.LOG.info("Configuring SNAP-Python interface...");
        ArrayList<String> command = new ArrayList<String>();
        command.add(pythonExecutable.toString());
        command.add(Paths.get(".", SNAPPYUTIL_PY_FILENAME).toString());
        command.add("--snap_home");
        command.add(SystemUtils.getApplicationHomeDir().getPath());
        command.add("--java_module");
        command.add(PyBridge.stripJarScheme(MODULE_CODE_BASE_PATH).toString());
        command.add("--force");
        command.add("--log_file");
        command.add(Paths.get(".", SNAPPYUTIL_LOG_FILENAME).toString());
        if (Debug.isEnabled()) {
            command.add("--log_level");
            command.add("DEBUG");
        }
        if ((defaultJvmHeapSpace = PyBridge.getDefaultJvmHeapSpace()) != null) {
            command.add("--jvm_max_mem");
            command.add(defaultJvmHeapSpace);
        }
        if ((javaHome = System.getProperty("java.home")) != null) {
            command.add("--java_home");
            command.add(javaHome);
        }
        if ((osArch = System.getProperty("os.arch")) != null) {
            command.add("--req_arch");
            command.add(osArch);
        }
        String commandLine = PyBridge.toCommandLine(command);
        SystemUtils.LOG.info(String.format("Executing command: [%s]\n", commandLine));
        try {
            Process process = new ProcessBuilder(new String[0]).command(command).directory(snappyDir.toFile()).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new IOException(String.format("Python configuration failed.\nCommand [%s]\nfailed with return code %s.\nPlease check the log file '%s'.", commandLine, exitCode, snappyDir.resolve(SNAPPYUTIL_LOG_FILENAME)));
            }
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("Python configuration failed.\nCommand [%s]\nfailed with exception %s.\nPlease check the log file '%s'.", commandLine, e.getMessage(), snappyDir.resolve(SNAPPYUTIL_LOG_FILENAME)), e);
        }
    }

    private static String getDefaultJvmHeapSpace() {
        long totalMemory = PyBridge.getTotalPhysicalMemory();
        if (totalMemory > 0L) {
            long memory = (long)((double)totalMemory * 0.7);
            long heapSpace = memory / 0x40000000L;
            return heapSpace + "G";
        }
        return null;
    }

    private static long getTotalPhysicalMemory() {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunMXBean = (OperatingSystemMXBean)operatingSystemMXBean;
            return sunMXBean.getTotalPhysicalMemorySize();
        }
        return -1L;
    }

    private static String toCommandLine(List<String> command) {
        StringBuilder sb = new StringBuilder();
        for (String arg : command) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(arg.contains(" ") ? String.format("\"%s\"", arg) : arg);
        }
        return sb.toString();
    }

    private static Path getResourcePath(String resource) {
        return MODULE_CODE_BASE_PATH.resolve(resource);
    }

    private static Path findModuleCodeBasePath() {
        return ResourceInstaller.findModuleCodeBasePath(PyBridge.class);
    }

    private static Path stripJarScheme(Path path) {
        String prefix = "jar:";
        String suffix = "!/";
        String uriString = path.toUri().toString();
        if (uriString.startsWith(prefix)) {
            int pos;
            uriString = uriString.endsWith(suffix) ? uriString.substring(prefix.length(), uriString.length() - suffix.length()) : ((pos = uriString.indexOf(suffix)) > 0 ? uriString.substring(prefix.length(), pos) : uriString.substring(prefix.length()));
            try {
                uriString = URLDecoder.decode(uriString, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            path = Paths.get(URI.create(uriString));
        }
        return path;
    }

    private static void unpackPythonModuleDir(Path pythonModuleDir) throws IOException {
        Files.createDirectories(pythonModuleDir, new FileAttribute[0]);
        TreeCopier.copy((Path)PyBridge.getResourcePath(SNAPPY_NAME), (Path)pythonModuleDir);
        SystemUtils.LOG.info(String.format("SNAP-Python module '%s' located at %s", SNAPPY_NAME, pythonModuleDir));
    }

    private static boolean isForceGeneratingNewPythonConfig() {
        return Config.instance().preferences().getBoolean(FORCE_PYTHON_CONFIG_PROPERTY, false);
    }

    private static Path getPythonExecutable() {
        return Paths.get(Config.instance().preferences().get(PYTHON_EXECUTABLE_PROPERTY, "python"), new String[0]);
    }

    private static Path getSnappyParentDir() {
        String pythonModuleDirStr = Config.instance().preferences().get(PYTHON_MODULE_DIR_PROPERTY, null);
        Path pythonModuleInstallDir = pythonModuleDirStr != null ? Paths.get(pythonModuleDirStr, new String[0]) : PYTHON_CONFIG_DIR;
        return pythonModuleInstallDir.toAbsolutePath().normalize();
    }

    private static void startPython(Path pythonModuleInstallDir) {
        String pythonVersion = PyLib.getPythonVersion();
        SystemUtils.LOG.info("Starting Python " + pythonVersion);
        if (!PyLib.isPythonRunning()) {
            PyLib.startPython(pythonModuleInstallDir.toString());
        } else {
            PyBridge.extendSysPath(pythonModuleInstallDir.toString());
        }
    }

    private static boolean loadPythonConfig() {
        Path pythonConfigFile;
        if (Files.isDirectory(PYTHON_CONFIG_DIR, new LinkOption[0]) && Files.isRegularFile(pythonConfigFile = PYTHON_CONFIG_DIR.resolve(SNAPPY_PROPERTIES_NAME), new LinkOption[0])) {
            Properties properties = new Properties();
            try {
                BufferedReader bufferedReader = Files.newBufferedReader(pythonConfigFile);
                Object object = null;
                try {
                    properties.load(bufferedReader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (bufferedReader != null) {
                        if (object != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            bufferedReader.close();
                        }
                    }
                }
                Set<String> keys = properties.stringPropertyNames();
                for (String key : keys) {
                    String value = properties.getProperty(key);
                    if (System.getProperty(key) == null) {
                        System.setProperty(key, value);
                    }
                    Config.instance().preferences().put(key, value);
                }
                SystemUtils.LOG.info(String.format("SNAP-Python configuration loaded from '%s'", pythonConfigFile));
                return true;
            }
            catch (IOException e) {
                SystemUtils.LOG.warning(String.format("Failed to load SNAP-Python configuration from '%s'", pythonConfigFile));
            }
        }
        return false;
    }

    private static boolean storePythonConfig(Path pythonExecutable, Path pythonModuleInstallDir) {
        Path pythonConfigFile = PYTHON_CONFIG_DIR.resolve(SNAPPY_PROPERTIES_NAME);
        try {
            if (!Files.exists(pythonConfigFile.getParent(), new LinkOption[0])) {
                Files.createDirectories(pythonConfigFile.getParent(), new FileAttribute[0]);
            }
            Properties properties = new Properties();
            properties.setProperty(PYTHON_EXECUTABLE_PROPERTY, pythonExecutable.toString());
            properties.setProperty(PYTHON_MODULE_DIR_PROPERTY, pythonModuleInstallDir.toString());
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(pythonConfigFile, new OpenOption[0]);){
                properties.store(bufferedWriter, "Created by " + PyBridge.class.getName());
            }
            SystemUtils.LOG.info(String.format("SNAP-Python configuration written to '%s'", pythonConfigFile));
            return true;
        }
        catch (IOException e) {
            SystemUtils.LOG.warning(String.format("Failed to store SNAP-Python configuration to '%s'", pythonConfigFile));
            return false;
        }
    }

    static {
        MODULE_CODE_BASE_PATH = PyBridge.findModuleCodeBasePath();
        PYTHON_CONFIG_DIR = SystemUtils.getApplicationDataDir((boolean)true).toPath().resolve(SNAP_PYTHON_DIRNAME);
    }
}

