/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator.ui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import javax.media.jai.JAI;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.esa.snap.smart.configurator.Benchmark;
import org.esa.snap.smart.configurator.BenchmarkSingleCalculus;
import org.esa.snap.smart.configurator.ConfigurationOptimizer;
import org.esa.snap.smart.configurator.PerformanceParameters;
import org.esa.snap.smart.configurator.ui.PerformancePanel;
import org.esa.snap.ui.AppContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;

public class BenchmarkDialog
extends DefaultSingleTargetProductDialog {
    private Benchmark benchmarkModel;
    private PerformancePanel perfPanel;

    public BenchmarkDialog(PerformancePanel perfPanel, String operatorName, Benchmark benchmarkModel, AppContext appContext) {
        super(operatorName, appContext, "Benchmark " + operatorName, null, false);
        this.benchmarkModel = benchmarkModel;
        this.getJDialog().setModal(true);
        this.perfPanel = perfPanel;
    }

    protected void executeOperator(Product targetProduct, ProgressHandleMonitor pm) throws Exception {
        OperatorProductReader opReader;
        Operator operator;
        boolean autoWriteDisabled;
        TargetProductSelectorModel model = this.getTargetProductSelector().getModel();
        if (model.getProductName() == null) {
            model.setProductName(targetProduct.getName());
        }
        Operator execOp = null;
        if (targetProduct.getProductReader() instanceof OperatorProductReader && (autoWriteDisabled = (operator = (opReader = (OperatorProductReader)targetProduct.getProductReader()).getOperatorContext().getOperator()).getSpi().getOperatorDescriptor().isAutoWriteDisabled())) {
            execOp = operator;
        }
        if (execOp == null) {
            WriteOp writeOp = new WriteOp(targetProduct, model.getProductFile(), model.getFormatName());
            writeOp.setDeleteOutputOnFailure(true);
            writeOp.setWriteEntireTileRows(true);
            writeOp.setClearCacheAfterRowWrite(false);
            execOp = writeOp;
        }
        SubProgressMonitor pm2 = (SubProgressMonitor)SubProgressMonitor.create((ProgressMonitor)pm, (int)95);
        if (execOp.canComputeTile() || execOp.canComputeTileStack()) {
            OperatorExecutor executor = OperatorExecutor.create(execOp);
            executor.execute((ProgressMonitor)pm2);
        } else {
            execOp.execute((ProgressMonitor)pm2);
        }
        pm2.done();
    }

    protected void onApply() {
        BenchmarkExecutor executor = new BenchmarkExecutor();
        ProgressHandleMonitor pm = ProgressHandleMonitor.create((String)"Running benchmark", (Cancellable)executor);
        executor.setProgressHandleMonitor(pm);
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)executor, (String)"Benchmarking....", (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
    }

    private class BenchmarkExecutor
    implements Runnable,
    Cancellable {
        ProgressHandleMonitor progressHandleMonitor = null;
        BenchmarkSingleCalculus currentBenchmarkSingleCalcul = null;
        private boolean canceled = false;

        private BenchmarkExecutor() {
        }

        private void setProgressHandleMonitor(ProgressHandleMonitor progressHandleMonitor) {
            this.progressHandleMonitor = progressHandleMonitor;
        }

        public boolean cancel() {
            BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(this.currentBenchmarkSingleCalcul);
            this.canceled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.canceled = false;
            if (this.progressHandleMonitor == null) {
                throw new IllegalStateException("Progress Handle Monitor not set");
            }
            String tmpdirPath = Paths.get(SystemUtils.getCacheDir().toString(), "snap-benchmark-tmp").toString();
            BenchmarkDialog.this.appContext.getPreferences().setPropertyString("last_product_save_dir", tmpdirPath);
            PerformanceParameters currentPerformanceParameters = ConfigurationOptimizer.getInstance().getActualPerformanceParameters();
            this.currentBenchmarkSingleCalcul = new BenchmarkSingleCalculus(currentPerformanceParameters.getTileHeight(), currentPerformanceParameters.getTileWidth(), currentPerformanceParameters.getCacheSize(), currentPerformanceParameters.getNbThreads());
            if (!BenchmarkDialog.this.benchmarkModel.isAlreadyInList(this.currentBenchmarkSingleCalcul)) {
                BenchmarkDialog.this.benchmarkModel.addBenchmarkCalcul(this.currentBenchmarkSingleCalcul);
            }
            try {
                this.progressHandleMonitor.beginTask("Benchmark running... ", BenchmarkDialog.this.benchmarkModel.getBenchmarkCalculus().size() * 100);
                List benchmarkSingleCalculusList = BenchmarkDialog.this.benchmarkModel.getBenchmarkCalculus();
                int executionOrder = 0;
                for (BenchmarkSingleCalculus benchmarkSingleCalcul : benchmarkSingleCalculusList) {
                    Product targetProduct;
                    this.progressHandleMonitor.getProgressHandle().progress(String.format("Benchmarking ( cache size:%d , nb threads:%d )", benchmarkSingleCalcul.getCacheSize(), benchmarkSingleCalcul.getNbThreads()));
                    BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(benchmarkSingleCalcul);
                    long startTime = System.currentTimeMillis();
                    try {
                        targetProduct = BenchmarkDialog.this.createTargetProduct();
                    }
                    catch (Throwable t) {
                        BenchmarkDialog.this.handleInitialisationError(t);
                        throw t;
                    }
                    if (targetProduct == null) {
                        throw new NullPointerException("Target product is null.");
                    }
                    BenchmarkDialog.this.executeOperator(targetProduct, this.progressHandleMonitor);
                    long endTime = System.currentTimeMillis();
                    benchmarkSingleCalcul.setExecutionTime(endTime - startTime);
                    benchmarkSingleCalcul.setExecutionOrder(executionOrder);
                    ++executionOrder;
                    SystemUtils.LOG.fine(String.format("Start time: %d, end time: %d, diff: %d", startTime, endTime, endTime - startTime));
                    JAI.getDefaultInstance().getTileCache().flush();
                }
                this.progressHandleMonitor.done();
            }
            catch (Exception ex) {
                SystemUtils.LOG.severe("Could not perform benchmark: " + ex.getMessage());
            }
            finally {
                BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(this.currentBenchmarkSingleCalcul);
                VirtualDir.deleteFileTree((File)new File(tmpdirPath));
            }
            this.managePostBenchmark();
        }

        private void managePostBenchmark() {
            if (!this.canceled) {
                BenchmarkSingleCalculus bestBenchmarkSingleCalcul = BenchmarkDialog.this.benchmarkModel.getFasterBenchmarkSingleCalculus();
                BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(bestBenchmarkSingleCalcul);
                this.showResults();
                BenchmarkDialog.this.perfPanel.updatePerformanceParameters(bestBenchmarkSingleCalcul);
            }
            BenchmarkDialog.this.close();
        }

        private void showResults() {
            class BenchmarkTableModel
            extends AbstractTableModel {
                final String[] columnNames;
                final int[][] data;

                BenchmarkTableModel() {
                    this.columnNames = BenchmarkDialog.this.benchmarkModel.getColumnsNamesWithoutTileSize();
                    this.data = BenchmarkDialog.this.benchmarkModel.getRowsToShowWhitoutTileSize();
                }

                public Class getColumnClass(int column) {
                    return Integer.class;
                }

                @Override
                public int getColumnCount() {
                    return this.columnNames.length;
                }

                @Override
                public int getRowCount() {
                    return this.data.length;
                }

                @Override
                public String getColumnName(int col) {
                    return this.columnNames[col];
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return this.data[row][col];
                }
            }
            BenchmarkTableModel tableModel = new BenchmarkTableModel();
            JTable table = new JTable(tableModel);
            TableRowSorter<BenchmarkTableModel> rowSorter = new TableRowSorter<BenchmarkTableModel>(tableModel);
            table.setRowSorter(rowSorter);
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
            tcr.setHorizontalAlignment(0);
            table.getColumnModel().getColumn(table.getColumnCount() - 1).setCellRenderer(tcr);
            JPanel panel = new JPanel(new BorderLayout(4, 4));
            JScrollPane panelTable = new JScrollPane(table);
            panel.add((Component)panelTable, "Center");
            NotifyDescriptor d = new NotifyDescriptor((Object)panel, "Benchmark results", -1, 1, null, null);
            DialogDisplayer.getDefault().notify(d);
        }
    }
}

