/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.eclipse.EclipseMenuItemUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class EclipseMenuUI
extends EclipseMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent x) {
        return new EclipseMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (!(menuItem instanceof JMenu) || !((JMenu)menuItem).isTopLevelMenu()) {
            super.paintBackground(g, menuItem, bgColor);
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = 0;
        int menuHeight = 0;
        if (JideSwingUtilities.getOrientationOf(menuItem) == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        Color darkShadow = UIDefaultsLookup.getColor("controlDkShadow");
        Color mouseHoverBackground = UIDefaultsLookup.getColor("Menu.mouseHoverBackground");
        Border mouseHoverBorder = UIDefaultsLookup.getBorder("Menu.mouseHoverBorder");
        Border mouseSelectedBorder = UIDefaultsLookup.getBorder("Menu.mouseSelectedBorder");
        if (menuItem.isOpaque()) {
            if (menuItem.getParent() != null) {
                g.setColor(menuItem.getParent().getBackground());
            } else {
                g.setColor(menuItem.getBackground());
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            if (mouseSelectedBorder != null) {
                mouseSelectedBorder.paintBorder(menuItem, g, 0, 0, menuWidth - 1, menuHeight);
            }
            g.setColor(mouseHoverBackground);
            g.fillRect(1, 1, menuWidth - 3, menuHeight - 2);
        } else if (this.isMouseOver() && model.isEnabled()) {
            if (mouseHoverBorder != null) {
                mouseHoverBorder.paintBorder(menuItem, g, 0, 0, menuWidth - 1, menuHeight);
            }
            g.setColor(mouseHoverBackground);
            g.fillRect(1, 1, menuWidth - 3, menuHeight - 2);
        }
        if (this.isDownArrowVisible(menuItem.getParent())) {
            int middle = menuWidth - 9;
            if (model.isSelected() || model.isArmed() || model.isPressed() || this.isMouseOver()) {
                JideSwingUtilities.paintArrow(g, this.selectionForeground, middle - 2, menuHeight / 2 - 1, 5, 0);
            } else {
                JideSwingUtilities.paintArrow(g, menuItem.getForeground(), middle - 2, menuHeight / 2 - 1, 5, 0);
            }
        }
        g.setColor(oldColor);
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    protected void updateMnemonicBinding() {
        int mnemonic = this.menuItem.getModel().getMnemonic();
        int[] shortcutKeys = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (shortcutKeys == null) {
            shortcutKeys = new int[]{8};
        }
        if (mnemonic == this.lastMnemonic) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (int shortcutKey : shortcutKeys) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, shortcutKey, false));
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, shortcutKey, true));
            }
        }
        if (mnemonic != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (int shortcutKey : shortcutKeys) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, false), "selectMenu");
            }
        }
        this.lastMnemonic = mnemonic;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMap am = super.createActionMap();
        if (am != null) {
            am.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return am;
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent c) {
        return new MenuHandler();
    }

    protected ChangeListener createChangeListener(JComponent c) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent c) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension d = c.getPreferredSize();
            return new Dimension(d.width, Short.MAX_VALUE);
        }
        return null;
    }

    public static void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new PostAction(menu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected static void appendPath(MenuElement[] path, MenuElement elem) {
        MenuElement[] newPath = new MenuElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = elem;
        MenuSelectionManager.defaultManager().setSelectedPath(newPath);
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i = path.length - 1; i >= 0; --i) {
            MenuElement elem = path[i];
            if (!(elem instanceof JPopupMenu)) continue;
            return (JPopupMenu)elem;
        }
        return null;
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (!(menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu() || !menuItem.getComponentOrientation().isLeftToRight())) {
            int defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            int defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            textRect.x = defaultShadowWidth + defaultTextIconGap;
        }
        if (!model.isEnabled()) {
            ++textRect.y;
            WindowsGraphicsUtils.paintText((Graphics)g, (AbstractButton)menuItem, (Rectangle)textRect, (String)text, (int)0);
        } else {
            FontMetrics fm = g.getFontMetrics();
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemonicIndex = -1;
            }
            Color oldColor = g.getColor();
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected() || this.isMouseOver()) {
                g.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent() - 1);
            g.setColor(oldColor);
        }
    }

    protected void setMouseOver(boolean over) {
        this.isMouseOver = over;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected boolean isMouseOver() {
        return this.isMouseOver;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && this.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                size.width += 11;
            } else {
                size.height += 11;
            }
        }
        return size;
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            JPopupMenu pm;
            if (!crossMenuMnemonic && (pm = EclipseMenuUI.getActivePopupMenu()) != null && pm != EclipseMenuUI.this.menuItem.getParent()) {
                return;
            }
            int key = EclipseMenuUI.this.menuItem.getMnemonic();
            if (key == 0) {
                return;
            }
            MenuElement[] path = e.getPath();
            if (this.lower((char)key) == this.lower(e.getKeyChar())) {
                JPopupMenu popupMenu = ((JMenu)EclipseMenuUI.this.menuItem).getPopupMenu();
                ArrayList<MenuElement> newList = new ArrayList<MenuElement>(Arrays.asList(path));
                newList.add(popupMenu);
                MenuElement[] sub = popupMenu.getSubElements();
                if (sub.length > 0) {
                    newList.add(sub[0]);
                }
                MenuSelectionManager manager = e.getMenuSelectionManager();
                MenuElement[] newPath = new MenuElement[]{};
                newPath = newList.toArray(newPath);
                manager.setSelectedPath(newPath);
                e.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
            char keyChar = e.getKeyChar();
            if (!Character.isLetterOrDigit(keyChar)) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            MenuElement[] selectedPath = manager.getSelectedPath();
            for (int i = selectedPath.length - 1; i >= 0; --i) {
                if (selectedPath[i] != EclipseMenuUI.this.menuItem) continue;
                JPopupMenu popupMenu = ((JMenu)EclipseMenuUI.this.menuItem).getPopupMenu();
                if (!popupMenu.isVisible()) {
                    return;
                }
                MenuElement[] items = popupMenu.getSubElements();
                MenuElement currentItem = selectedPath[selectedPath.length - 1];
                int currentIndex = -1;
                int matches = 0;
                int firstMatch = -1;
                int[] indexes = null;
                for (int j = 0; j < items.length; ++j) {
                    int key = ((JMenuItem)items[j]).getMnemonic();
                    if (this.lower((char)key) == this.lower(keyChar)) {
                        if (matches == 0) {
                            firstMatch = j;
                            ++matches;
                        } else {
                            if (indexes == null) {
                                indexes = new int[items.length];
                                indexes[0] = firstMatch;
                            }
                            indexes[matches++] = j;
                        }
                    }
                    if (currentItem != items[j]) continue;
                    currentIndex = matches - 1;
                }
                if (matches != 0) {
                    if (matches == 1) {
                        JMenuItem item = (JMenuItem)items[firstMatch];
                        if (!(item instanceof JMenu)) {
                            manager.clearSelectedPath();
                            item.doClick();
                        }
                    } else {
                        MenuElement newItem = null;
                        if (indexes != null) {
                            newItem = items[indexes[(currentIndex + 1) % matches]];
                        }
                        MenuElement[] newPath = new MenuElement[path.length + 2];
                        System.arraycopy(path, 0, newPath, 0, path.length);
                        newPath[path.length] = popupMenu;
                        newPath[path.length + 1] = newItem;
                        manager.setSelectedPath(newPath);
                    }
                }
                e.consume();
                return;
            }
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private char lower(char keyChar) {
            return Character.toLowerCase(keyChar);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            Component comp;
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            if (!EclipseMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < EclipseMenuUI.this.menuItem.getWidth() && p.y >= 0 && p.y < EclipseMenuUI.this.menuItem.getHeight()) {
                JMenu menu = (JMenu)EclipseMenuUI.this.menuItem;
                MenuElement[] selectedPath = manager.getSelectedPath();
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.isTopLevelMenu() || menu.getDelay() == 0 || e.getID() == 506) {
                        EclipseMenuUI.appendPath(path, menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(path);
                        EclipseMenuUI.setupPostTimer(menu);
                    }
                }
            } else if (e.getID() == 502 && (comp = manager.componentForPoint(e.getComponent(), e.getPoint())) == null) {
                manager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public EclipseMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu m, EclipseMenuUI ui) {
            this.menu = m;
            this.ui = ui;
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    private static class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuSelected(MenuEvent e) {
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager.isComponentPartOfCurrentMenu(m)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            MenuElement[] selectedPath;
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu menu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (menu.getParent() instanceof JMenuBar || menu.getParent() instanceof TopLevelMenuContainer) {
                if (menu.isSelected()) {
                    manager.clearSelectedPath();
                } else {
                    Container cnt = this.getFirstParentMenuElement(menu);
                    if (cnt != null && cnt instanceof MenuElement) {
                        ArrayList<Container> parents = new ArrayList<Container>();
                        while (cnt instanceof MenuElement) {
                            parents.add(0, cnt);
                            if (cnt instanceof JPopupMenu) {
                                cnt = (Container)((JPopupMenu)cnt).getInvoker();
                                continue;
                            }
                            cnt = this.getFirstParentMenuElement(cnt);
                        }
                        MenuElement[] me = new MenuElement[parents.size() + 1];
                        for (int i = 0; i < parents.size(); ++i) {
                            Container container = (Container)parents.get(i);
                            me[i] = (MenuElement)((Object)container);
                        }
                        me[parents.size()] = menu;
                        manager.setSelectedPath(me);
                    } else {
                        MenuElement[] me = new MenuElement[]{menu};
                        manager.setSelectedPath(me);
                    }
                }
            }
            if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                    EclipseMenuUI.appendPath(selectedPath, menu.getPopupMenu());
                } else {
                    EclipseMenuUI.setupPostTimer(menu);
                }
            }
        }

        protected Container getFirstParentMenuElement(Component comp) {
            for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof MenuElement)) continue;
                return parent;
            }
            return null;
        }

        public void mouseReleased(MouseEvent e) {
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu menu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
            if (!e.isConsumed()) {
                manager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu menu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        EclipseMenuUI.appendPath(EclipseMenuUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(EclipseMenuUI.this.getPath());
                        EclipseMenuUI.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            EclipseMenuUI.this.setMouseOver(true);
            EclipseMenuUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent e) {
            EclipseMenuUI.this.setMouseOver(false);
            EclipseMenuUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            if (!(EclipseMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu menu = (JMenu)EclipseMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("mnemonic")) {
                EclipseMenuUI.this.updateMnemonicBinding();
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu menu, boolean shouldForce) {
            this.menu = menu;
            this.force = shouldForce;
        }

        public void actionPerformed(ActionEvent e) {
            JPopupMenu pm;
            if (!crossMenuMnemonic && (pm = EclipseMenuUI.getActivePopupMenu()) != null && pm != this.menu.getParent()) {
                return;
            }
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container cnt = this.menu.getParent();
                if (cnt != null && cnt instanceof JMenuBar) {
                    MenuElement[] subElements = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] me = subElements.length > 0 ? new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu(), subElements[0]} : new MenuElement[]{(MenuElement)((Object)cnt), this.menu, this.menu.getPopupMenu()};
                    defaultManager.setSelectedPath(me);
                }
            } else {
                MenuElement[] path = defaultManager.getSelectedPath();
                if (path.length > 0 && path[path.length - 1] == this.menu) {
                    EclipseMenuUI.appendPath(path, this.menu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

