/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.tilecache;

import com.bc.ceres.jai.tilecache.MemoryTile;
import com.bc.ceres.jai.tilecache.SwapSpace;
import com.bc.ceres.jai.tilecache.SwappedTile;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultSwapSpace
implements SwapSpace {
    private final File swapDir;
    private final Logger logger;
    private final Map<Object, SwappedTile> swappedTiles;

    public DefaultSwapSpace(File swapDir) {
        this(swapDir, Logger.getLogger(System.getProperty("ceres.context", "ceres")));
    }

    public DefaultSwapSpace(File swapDir, Logger logger) {
        this.swapDir = swapDir;
        this.logger = logger;
        this.swappedTiles = new HashMap<Object, SwappedTile>(1009);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (Object key : this.swappedTiles.keySet()) {
            this.swappedTiles.get(key).delete();
        }
    }

    @Override
    public synchronized boolean storeTile(MemoryTile mt) {
        SwappedTile st = this.swappedTiles.get(mt.getKey());
        if (st == null) {
            try {
                st = new SwappedTile(mt, this.swapDir);
                if (!st.isAvailable()) {
                    long t1 = System.currentTimeMillis();
                    st.storeTile(mt.getTile());
                    long t2 = System.currentTimeMillis();
                    st.getFile().deleteOnExit();
                    this.logger.log(Level.FINEST, "Tile stored: " + st.getFile() + " (" + (t2 - t1) + " ms)");
                }
                this.swappedTiles.put(mt.getKey(), st);
                return true;
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Tile NOT stored: " + st.getFile(), e);
                this.handleTileStoreFailed(mt, e);
            }
        }
        return false;
    }

    @Override
    public synchronized MemoryTile restoreTile(RenderedImage owner, int tileX, int tileY) {
        Object key = DefaultSwapSpace.hashKey(owner, tileX, tileY);
        SwappedTile st = this.swappedTiles.get(key);
        if (st == null) {
            return null;
        }
        try {
            long t1 = System.currentTimeMillis();
            Raster tile = st.restoreTile();
            long t2 = System.currentTimeMillis();
            this.logger.log(Level.FINEST, "Tile restored: " + st.getFile() + " (" + (t2 - t1) + " ms)");
            return new MemoryTile(owner, tileX, tileY, tile, st.getTileCacheMetric());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Tile NOT restored: " + st.getFile());
            return this.handleTileRestoreFailed(owner, tileX, tileY, e);
        }
    }

    @Override
    public synchronized boolean deleteTile(RenderedImage owner, int tileX, int tileY) {
        Object key = DefaultSwapSpace.hashKey(owner, tileX, tileY);
        SwappedTile st = this.swappedTiles.remove(key);
        if (st == null || !st.getFile().exists()) {
            return false;
        }
        boolean deleted = st.delete();
        if (deleted) {
            this.logger.log(Level.FINEST, "Tile deleted: " + st.getFile());
        } else {
            this.logger.log(Level.WARNING, "Tile NOT deleted: " + st.getFile());
        }
        return deleted;
    }

    protected void handleTileStoreFailed(MemoryTile mt, IOException e) {
        this.deleteTile(mt.getOwner(), mt.getTileX(), mt.getTileY());
    }

    protected MemoryTile handleTileRestoreFailed(RenderedImage owner, int tileX, int tileY, IOException e) {
        return null;
    }

    private static Object hashKey(RenderedImage owner, int tileX, int tileY) {
        return MemoryTile.hashKey(owner, tileX, tileY);
    }
}

