/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.compiler.CodeMapper;
import com.bc.ceres.jai.opimage.ExpressionCode;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ExpressionCodeGenerator {
    private static final String HEAD_COMMENT = "/*\n * This is machine-genereated code, DO NOT EDIT!\n * Code generated by {0}.\n */\n";
    private static final String HEAD_PART = "package {0};\n\nimport javax.media.jai.ImageLayout;\nimport javax.media.jai.PointOpImage;\nimport javax.media.jai.PixelAccessor;\nimport javax.media.jai.UnpackedImageData;\nimport java.awt.Rectangle;\nimport java.awt.image.Raster;\nimport java.awt.image.WritableRaster;\nimport java.util.Vector;\nimport java.util.Map;\nimport static java.lang.Math.*;\n\npublic final class {1} extends PointOpImage '{'\n\n    public {1}(Vector sources, Map config, ImageLayout layout) '{'\n        super(sources, layout, config, true);\n        // Set flag to permit in-place operation.\n        permitInPlaceOperation();\n    '}'\n\n    protected void computeRect(Raster[] srcRasters,\n                               WritableRaster destRaster,\n                               Rectangle destRectangle) '{'\n\n";
    private static final String SRC_DEF_PART = "        final PixelAccessor src{0}Acc = new PixelAccessor(getSourceImage({0}));\n        final UnpackedImageData src{0}Pixels = src{0}Acc.getPixels(srcRasters[{0}], destRectangle, srcRasters[{0}].getSampleModel().getDataType(), false);\n        final int src{0}LineStride = src{0}Pixels.lineStride;\n        final int src{0}PixelStride = src{0}Pixels.pixelStride;\n        int src{0}LineOffset = src{0}Pixels.bandOffsets[0];\n        final {1}[] src{0}Data = src{0}Pixels.get{2}Data(0);\n\n";
    private static final String DST_DEF_PART = "        final PixelAccessor destAcc = new PixelAccessor(this);\n        final UnpackedImageData destPixels = destAcc.getPixels(destRaster, destRectangle, getSampleModel().getDataType(), true);\n        final int destLineStride = destPixels.lineStride;\n        final int destPixelStride = destPixels.pixelStride;\n        int destLineOffset = destPixels.bandOffsets[0];\n        final {1}[] destData = destPixels.get{2}Data(0);\n\n";
    private static final String Y_LOOP_PART = "        final int width = destRectangle.width;\n        final int height = destRectangle.height;\n\n        for (int y = 0; y < height; y++) {\n";
    private static final String SRC_OFFS_PART = "            int src{0}PixelOffset = src{0}LineOffset;\n            src{0}LineOffset += src{0}LineStride;\n\n";
    private static final String X_LOOP_PART = "            int destPixelOffset = destLineOffset;\n            destLineOffset += destLineStride;\n\n            for (int x = 0; x < width; x++) {\n";
    private static final String EXPR_VAR_PART = "                final {1} _{0} = src{0}Data[src{0}PixelOffset];\n";
    private static final String EXPR_PART = "                destData[destPixelOffset] = ({0})({1});\n\n";
    private static final String SRC_PIXEL_INC_PART = "                src{0}PixelOffset += src{0}PixelStride;\n";
    private static final String FINAL_PART = "                destPixelOffset += destPixelStride;\n            } // next x\n        } // next y\n\n        destAcc.setPixels(destPixels);\n    }\n}\n";

    public static ExpressionCode generate(String packageName, String className, Map<String, RenderedImage> sourceMap, int dataType, String expression) {
        int i;
        MyNameMapper mapper = new MyNameMapper(sourceMap);
        CodeMapper.CodeMapping codeMapping = CodeMapper.mapCode(expression, mapper);
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(MessageFormat.format(HEAD_COMMENT, ExpressionCodeGenerator.class.getName()));
        codeBuilder.append(MessageFormat.format(HEAD_PART, packageName, className));
        Vector sources = mapper.sources;
        for (int i2 = 0; i2 < sources.size(); ++i2) {
            String typeName = ExpressionCodeGenerator.getTypeName(sources, i2);
            codeBuilder.append(MessageFormat.format(SRC_DEF_PART, String.valueOf(i2), typeName, ExpressionCodeGenerator.getCamelCase(typeName)));
        }
        String dstTypeName = ExpressionCodeGenerator.getTypeName(dataType);
        codeBuilder.append(MessageFormat.format(DST_DEF_PART, String.valueOf(sources.size()), dstTypeName, ExpressionCodeGenerator.getCamelCase(dstTypeName)));
        codeBuilder.append(Y_LOOP_PART);
        for (i = 0; i < sources.size(); ++i) {
            codeBuilder.append(MessageFormat.format(SRC_OFFS_PART, String.valueOf(i)));
        }
        codeBuilder.append(X_LOOP_PART);
        for (i = 0; i < sources.size(); ++i) {
            String typeName = ExpressionCodeGenerator.getTypeName(sources, i);
            codeBuilder.append(MessageFormat.format(EXPR_VAR_PART, String.valueOf(i), typeName));
        }
        codeBuilder.append(MessageFormat.format(EXPR_PART, dstTypeName, codeMapping.getMappedCode()));
        for (i = 0; i < sources.size(); ++i) {
            codeBuilder.append(MessageFormat.format(SRC_PIXEL_INC_PART, String.valueOf(i)));
        }
        codeBuilder.append(FINAL_PART);
        return new ExpressionCode(packageName + "." + className, codeBuilder.toString(), sources);
    }

    private static String getTypeName(Vector<RenderedImage> sources, int i) {
        return ExpressionCodeGenerator.getTypeName(sources.get(i).getSampleModel().getDataType());
    }

    static String getCamelCase(String typeName) {
        return Character.toUpperCase(typeName.charAt(0)) + typeName.substring(1);
    }

    static String getTypeName(int type) {
        String typeName = type == 0 ? "byte" : (type == 2 ? "short" : (type == 1 ? "short" : (type == 3 ? "int" : (type == 4 ? "float" : (type == 5 ? "double" : "double")))));
        return typeName;
    }

    private static class MyNameMapper
    implements CodeMapper.NameMapper {
        private final Map<String, RenderedImage> imageMap;
        private final Vector<RenderedImage> sources = new Vector(16);
        private final Map<String, Integer> indexMap = new HashMap<String, Integer>(16);
        private int counter;

        public MyNameMapper(Map<String, RenderedImage> imageMap) {
            this.imageMap = imageMap;
        }

        @Override
        public String mapName(String name) {
            RenderedImage image;
            boolean b = this.imageMap.containsKey(name);
            if (!b) {
                return null;
            }
            if (!this.indexMap.containsKey(name)) {
                this.indexMap.put(name, this.counter++);
                this.sources.add(this.imageMap.get(name));
            }
            if ((image = this.imageMap.get(name)).getSampleModel().getDataType() == 1) {
                return MessageFormat.format("(_{0} & 0xffff)", this.indexMap.get(name));
            }
            return MessageFormat.format("_{0}", this.indexMap.get(name));
        }
    }
}

