/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.js;

import com.bc.ceres.jai.js.JsJaiFunction;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsJai
extends ScriptableObject {
    static int frameId = 0;
    static HashMap<Integer, JFrame> frames = new HashMap();

    public JsJai() {
        this.construct();
    }

    public JsJai(Scriptable scope, Scriptable prototype) {
        super(scope, prototype);
        this.construct();
    }

    public String getClassName() {
        return "jai";
    }

    public Object getDefaultValue(Class aClass) {
        if (aClass == String.class) {
            return "[" + this.getClassName() + "]";
        }
        if (aClass == Boolean.class) {
            return false;
        }
        if (aClass == Number.class) {
            return 0;
        }
        if (aClass == Scriptable.class) {
            return this;
        }
        return null;
    }

    private void construct() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        List operationDescriptors = operationRegistry.getDescriptors(OperationDescriptor.class);
        for (OperationDescriptor operationDescriptor : operationDescriptors) {
            Field[] fields;
            JsJaiFunction jaiFunction = new JsJaiFunction(operationDescriptor);
            this.defineProperty(jaiFunction.getClassName(), (Object)jaiFunction, 1);
            for (Field field : fields = operationDescriptor.getClass().getFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                try {
                    this.defineProperty(field.getName(), field.get(operationDescriptor), 1);
                }
                catch (IllegalAccessException e) {
                    System.out.println("Error: operationDescriptor=" + operationDescriptor + ", field=" + field + ", e=" + e);
                }
            }
        }
        this.defineProperty("INTERP_NEAREST", Interpolation.getInstance((int)0), 1);
        this.defineProperty("INTERP_BILINEAR", Interpolation.getInstance((int)1), 1);
        this.defineProperty("INTERP_BICUBIC", Interpolation.getInstance((int)2), 1);
        this.defineProperty("INTERP_BICUBIC_2", Interpolation.getInstance((int)3), 1);
        this.defineFunctionProperties(new String[]{"show", "help"}, JsJai.class, 2);
    }

    public static int show(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int frameId;
        RenderedImage renderedImage = args.length > 0 ? (RenderedImage)Context.jsToJava((Object)args[0], RenderedImage.class) : null;
        int n = frameId = args.length > 1 ? (Integer)Context.jsToJava((Object)args[1], Integer.class) : -1;
        Image image = renderedImage instanceof PlanarImage ? ((PlanarImage)renderedImage).getAsBufferedImage() : (renderedImage instanceof Image ? (Image)((Object)renderedImage) : new BufferedImage(512, 512, 10));
        JFrame frame = frames.get(frameId);
        if (frame != null) {
            frame.getContentPane().removeAll();
        } else {
            frameId = JsJai.frameId++;
            frame = new JFrame();
            frame.setDefaultCloseOperation(2);
            frames.put(frameId, frame);
        }
        frame.setTitle("Image #" + frameId);
        frame.getContentPane().add(new JScrollPane(new JLabel(new ImageIcon(image))));
        frame.pack();
        frame.setVisible(true);
        return frameId;
    }

    public static void help(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0) {
            Object[] objects;
            for (Object object : objects = thisObj.getIds()) {
                System.out.println("jai." + object + " = " + thisObj.get(object.toString(), thisObj));
            }
            JsJai.printOperatorList();
        } else {
            for (Object arg : args) {
                JsJai.printOperatorUsage(Context.toString((Object)arg));
            }
        }
    }

    public static void printOperatorList() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        List descriptors = operationRegistry.getDescriptors(OperationDescriptor.class);
        Collections.sort(descriptors, new Comparator<OperationDescriptor>(){

            @Override
            public int compare(OperationDescriptor descriptor1, OperationDescriptor descriptor2) {
                return descriptor1.getName().compareTo(descriptor2.getName());
            }
        });
        int columnCount = 0;
        for (OperationDescriptor descriptor : descriptors) {
            columnCount = Math.max(columnCount, descriptor.getName().length());
        }
        for (OperationDescriptor descriptor : descriptors) {
            String namePart = descriptor.getName();
            if (namePart.length() < columnCount) {
                namePart = namePart + JsJai.spaces(columnCount - namePart.length());
            }
            String[][] resources = descriptor.getResources(Locale.getDefault());
            String description = resources[3][1];
            System.out.println(namePart + " - " + description);
        }
    }

    private static void printOperatorUsage(String name) {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        OperationDescriptor descriptor = (OperationDescriptor)operationRegistry.getDescriptor(OperationDescriptor.class, name);
        if (descriptor == null) {
            System.out.println("Unknown operation '" + name + "'");
            return;
        }
        String[][] resources = descriptor.getResources(Locale.getDefault());
        String globalName = resources[0][1];
        String description = resources[3][1];
        String[] sourceNames = descriptor.getSourceNames();
        Class[] sourceTypes = descriptor.getSourceClasses("rendered");
        ParameterListDescriptor parameterListDescriptor = descriptor.getParameterListDescriptor("rendered");
        String[] paramNames = parameterListDescriptor.getParamNames();
        Class[] paramTypes = parameterListDescriptor.getParamClasses();
        StringBuilder text = new StringBuilder();
        text.append("Usage: ");
        text.append(globalName);
        text.append('(');
        StringBuilder paramListText = new StringBuilder();
        if (sourceNames != null) {
            for (String sourceName : sourceNames) {
                if (paramListText.length() > 0) {
                    paramListText.append(", ");
                }
                paramListText.append(sourceName);
            }
        }
        if (paramNames != null) {
            for (String paramName : paramNames) {
                if (paramListText.length() > 0) {
                    paramListText.append(", ");
                }
                paramListText.append(paramName);
                Object defaultValue = parameterListDescriptor.getParamDefaultValue(paramName);
                if (defaultValue == ParameterListDescriptor.NO_PARAMETER_DEFAULT) continue;
                paramListText.append("=");
                paramListText.append(JsJai.format(defaultValue));
            }
        }
        text.append((CharSequence)paramListText);
        text.append(')');
        text.append('\n');
        text.append("Description: ");
        text.append(description);
        text.append('\n');
        text.append("Arguments:\n");
        if (sourceNames != null) {
            for (int i = 0; i < sourceNames.length; ++i) {
                String sourceName = sourceNames[i];
                Class sourceType = sourceTypes[i];
                text.append("  ");
                text.append(sourceName);
                text.append(": ");
                text.append("A source.");
                text.append(" (" + sourceType.getName() + ")");
                text.append('\n');
            }
        }
        if (paramNames != null) {
            for (int i = 0; i < paramNames.length; ++i) {
                String paramName = paramNames[i];
                Class paramType = paramTypes[i];
                text.append("  ");
                text.append(paramName);
                text.append(": ");
                text.append(resources[6 + i][1]);
                text.append(" (" + paramType.getName() + ")");
                text.append('\n');
            }
        }
        System.out.println(text);
    }

    private static String format(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(JsJai.format(Array.get(value, i)));
            }
            builder.append('}');
            return builder.toString();
        }
        if (EnumeratedParameter.class.isAssignableFrom(type)) {
            return ((EnumeratedParameter)value).getName();
        }
        if (Interpolation.class.isAssignableFrom(type)) {
            if (Interpolation.getInstance((int)0).equals(value)) {
                return "INTERP_NEAREST";
            }
            if (Interpolation.getInstance((int)1).equals(value)) {
                return "INTERP_BILINEAR";
            }
            if (Interpolation.getInstance((int)2).equals(value)) {
                return "INTERP_BICUBIC";
            }
            if (Interpolation.getInstance((int)3).equals(value)) {
                return "INTERP_BICUBIC_2";
            }
        } else if (CharSequence.class.isAssignableFrom(type)) {
            return "\"" + String.valueOf(value) + "\"";
        }
        return String.valueOf(value);
    }

    private static String spaces(int n) {
        char[] c = new char[n];
        Arrays.fill(c, ' ');
        return new String(c);
    }
}

