/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.interpolators;

import java.io.Serializable;
import java.util.Arrays;

class PolynomialFunction
implements Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    public PolynomialFunction(double[] c) {
        int n;
        if (n == 0) {
            throw new IllegalArgumentException("empty polynomials coefficients array");
        }
        for (n = c.length; n > 1 && c[n - 1] == 0.0; --n) {
        }
        this.coefficients = new double[n];
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    protected static double evaluate(double[] coefficients, double argument) {
        int n = coefficients.length;
        if (n == 0) {
            throw new IllegalArgumentException("empty polynomials coefficients array");
        }
        double result = coefficients[n - 1];
        for (int j = n - 2; j >= 0; --j) {
            result = argument * result + coefficients[j];
        }
        return result;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            s.append(Double.toString(this.coefficients[0]));
        }
        for (int i = 1; i < this.coefficients.length; ++i) {
            if (this.coefficients[i] == 0.0) continue;
            if (s.length() > 0) {
                if (this.coefficients[i] < 0.0) {
                    s.append(" - ");
                } else {
                    s.append(" + ");
                }
            } else if (this.coefficients[i] < 0.0) {
                s.append("-");
            }
            double absAi = Math.abs(this.coefficients[i]);
            if (absAi - 1.0 != 0.0) {
                s.append(Double.toString(absAi));
                s.append(' ');
            }
            s.append("x");
            if (i <= 1) continue;
            s.append('^');
            s.append(Integer.toString(i));
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction other = (PolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }
}

