/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product.metadata;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.ui.product.metadata.MetadataElementInnerNode;
import org.esa.snap.ui.product.metadata.MetadataTableArrayElemLeaf;
import org.esa.snap.ui.product.metadata.MetadataTableElement;
import org.esa.snap.ui.product.metadata.MetadataTableLeaf;
import org.openide.nodes.AbstractNode;

public class MetadataTableInnerElement
implements MetadataTableElement {
    private final MetadataElement metadataElement;
    private final MetadataTableElement[] metadataTableElements;

    public MetadataTableInnerElement(MetadataElement metadataElement) {
        this.metadataElement = metadataElement;
        this.metadataTableElements = MetadataTableInnerElement.getChildrenElementsFromElement(metadataElement);
    }

    @Override
    public MetadataTableElement[] getMetadataTableElements() {
        return this.metadataTableElements;
    }

    @Override
    public String getName() {
        return this.metadataElement.getName();
    }

    @Override
    public AbstractNode createNode() {
        return new MetadataElementInnerNode(this);
    }

    private static MetadataTableElement[] getChildrenElementsFromElement(MetadataElement metadataElement) {
        MetadataElement[] elements = metadataElement.getElements();
        MetadataAttribute[] attributes = metadataElement.getAttributes();
        ArrayList<MetadataTableElement> metadataTableElementList = new ArrayList<MetadataTableElement>();
        for (MetadataElement metadataElement2 : elements) {
            metadataTableElementList.add(new MetadataTableInnerElement(metadataElement2));
        }
        for (MetadataElement metadataElement3 : attributes) {
            long dataElemSize = metadataElement3.getNumDataElems();
            if (dataElemSize > 1L) {
                int dataType = metadataElement3.getDataType();
                ProductData data = metadataElement3.getData();
                if ((ProductData.isFloatingPointType((int)dataType) || ProductData.isIntType((int)dataType)) && !(data instanceof ProductData.UTC)) {
                    MetadataTableInnerElement.addMetadataAttributes((MetadataAttribute)metadataElement3, data, metadataTableElementList);
                    continue;
                }
                metadataTableElementList.add(new MetadataTableLeaf((MetadataAttribute)metadataElement3));
                continue;
            }
            metadataTableElementList.add(new MetadataTableLeaf((MetadataAttribute)metadataElement3));
        }
        return metadataTableElementList.toArray(new MetadataTableElement[metadataTableElementList.size()]);
    }

    private static void addMetadataAttributes(MetadataAttribute attribute, ProductData data, List<MetadataTableElement> metadataTableElementList) {
        String name = attribute.getName();
        String unit = attribute.getUnit();
        String description = attribute.getDescription();
        for (int j = 0; j < data.getNumElems(); ++j) {
            String elemName = String.format("%s.%d", name, j + 1);
            metadataTableElementList.add(new MetadataTableArrayElemLeaf(elemName, unit, description, data, j));
        }
    }
}

