/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.product.LoadSaveRasterDataNodesConfigurationsComponent;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.ImageUtilities;

public class LoadSaveRasterDataNodesConfigurationsProvider {
    private final LoadSaveRasterDataNodesConfigurationsComponent component;
    private AbstractButton loadButton;
    private AbstractButton saveButton;

    public LoadSaveRasterDataNodesConfigurationsProvider(LoadSaveRasterDataNodesConfigurationsComponent component) {
        this.component = component;
    }

    public AbstractButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = LoadSaveRasterDataNodesConfigurationsProvider.createButton("tango/22x22/actions/document-open.png");
            this.loadButton.setToolTipText("Load configuration");
            this.loadButton.addActionListener(new LoadConfigurationActionListener());
        }
        return this.loadButton;
    }

    public AbstractButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = LoadSaveRasterDataNodesConfigurationsProvider.createButton("tango/22x22/actions/document-save-as.png");
            this.saveButton.setToolTipText("Save configuration");
            this.saveButton.addActionListener(new SaveConfigurationActionListener());
        }
        return this.saveButton;
    }

    private static AbstractButton createButton(String s) {
        return ToolButtonFactory.createButton(ImageUtilities.loadImageIcon((String)s, (boolean)false), false);
    }

    private static File getBandSetsDataDir() {
        File file = new File(SystemUtils.getAuxDataPath().toFile(), "band_sets");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private class SaveConfigurationActionListener
    implements ActionListener {
        private SaveConfigurationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File currentDirectory = LoadSaveRasterDataNodesConfigurationsProvider.getBandSetsDataDir();
            JFileChooser fileChooser = new JFileChooser(currentDirectory);
            File suggestedFile = new File(currentDirectory + File.separator + "config.txt");
            int fileCounter = 1;
            while (suggestedFile.exists()) {
                suggestedFile = new File("config" + fileCounter + ".txt");
            }
            fileChooser.setSelectedFile(suggestedFile);
            if (fileChooser.showSaveDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent()) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String[] bandNames;
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    for (String bandName : bandNames = LoadSaveRasterDataNodesConfigurationsProvider.this.component.getRasterDataNodeNamesToWrite()) {
                        writer.write(bandName + "\n");
                    }
                    writer.close();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent(), "Could not save configuration");
                }
            }
        }
    }

    private class LoadConfigurationActionListener
    implements ActionListener {
        private LoadConfigurationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File currentDirectory = LoadSaveRasterDataNodesConfigurationsProvider.getBandSetsDataDir();
            JFileChooser fileChooser = new JFileChooser(currentDirectory);
            if (fileChooser.showOpenDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent()) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String readBandName;
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    ArrayList<String> bandNameList = new ArrayList<String>();
                    while ((readBandName = reader.readLine()) != null) {
                        bandNameList.add(readBandName);
                    }
                    reader.close();
                    String[] bandNames = bandNameList.toArray(new String[bandNameList.size()]);
                    LoadSaveRasterDataNodesConfigurationsProvider.this.component.setReadRasterDataNodeNames(bandNames);
                }
                catch (IOException e1) {
                    AbstractDialog.showInformationDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent(), "Could not load configuration", "Information");
                }
            }
        }
    }
}

